#ifndef  BRPAQU_H_SEEN
#define  BRPAQU_H_SEEN

/* ----------------------------------------
     Projet BAORadio --- LAL 
     Juin 2008 , M.Taurigna , R. Ansari 
-------------------------------------------  */

#include <stdio.h>
#include <iostream>
#include <string>
#include "brtypes.h"

using namespace std;

// Taille entete/trailer en octets 
#define BRHDRSIZE 24
// Actuellement le trailer est vire ...
/* #define BRTRLSIZE 16  */
#define BRTRLSIZE 0
// Offset du time-tag
#define BRTMTAGOFF 8

// Structure correspondant a HEADER-DATA-TRAILER
class BRPaquet {
 public:
  BRPaquet(Byte* src, Byte* dst, int paqsz=4096);
  //  ~BRPaquet();

  // Acces diverses tailles 
  inline int PaquetSize() { return sz_; }
  inline int DataSize() { return sz_-(BRHDRSIZE+BRTRLSIZE); }

  inline int HeaderSize() { return BRHDRSIZE; }
  inline int TrailerSize() { return BRTRLSIZE; }

  // Acces differentes zone memoire
  inline Byte* Data() { return dst_+BRHDRSIZE; }
  inline Byte* Header() { return dst_; }
  inline Byte* Trailer() { return (dst_+sz_-BRTRLSIZE); }
  
  // Valeurs differentes zones HDR/TRL
  inline UInt64 HDRMarker() {return *((UInt64*)dst_);}
  inline UInt64 TRLMarker() {return *((UInt64*)(dst_+sz_-BRTRLSIZE));}
  inline UInt64 TimeTag() {return *((UInt64*)(dst_+BRTMTAGOFF));}

  // pour faire un print de la structure
  void Print(ostream & os, int nelt=8, bool prht=true);

  // protected:
  // donnees membres
  int sz_; //taille du paquet 
  Byte* dst_;  
};

#endif
