#ifndef  PCIEWRAP_H_SEEN
#define  PCIEWRAP_H_SEEN

#include "machdefs.h"
#include <string>

/* 
   Classe interface aux fonctions d'I/O PCIExpress 
   pour la carte de reception optique BAORadio
   R. Ansari                        Juin 2008
*/

using namespace std;

class PCIEWException {
  public:
  explicit PCIEWException(const char * m) { msg = m; }
  explicit PCIEWException(const string& m) { msg = m; }
  virtual string const& Msg() const  {return msg;}
  virtual const char* what() {return msg.c_str(); }
 private:
  string msg;
};


class PCIEWrapper {
public:
// Constructeur - fait l'initialisation
          PCIEWrapper(); 
// destructeur - libere la memoire allouee
  virtual ~PCIEWrapper();

// Retourne le nombre d'octets a lire 
  uint_4  NBytesToRead();

// Lecture du buffer de la carte 
  uint_4  Read(uint_1* buff, uint_4 nbytes);
};


#endif
