#include "racqumem.h"

//----------------------------------------------------------------
// ---- classes de gestion memoire pour acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------


RAcqMemZoneMgr::RAcqMemZoneMgr(uint_4 nz, uint_4 np, uint_4 psz)
  :  mex(true), nzones(nz), npaq(np), paqsz(psz), stop_(false)
{
  St_MemZ st;
  st.act = (uint_4)MemZA_None;
  st.stat = (uint_8)MemZS_Free;
  for(int k=0; k<3; k++) st.nbact[k] = 0;
  uint_8 mzsz = npaq*paqsz;

  for(int k=0; k<NbZones(); k++) {
  	memzones.push_back(new Byte[mzsz] );
  	states.push_back(st);
  }	
}

RAcqMemZoneMgr::~RAcqMemZoneMgr()
{
  for(uint_4 k=0; k<NbZones(); k++) delete[] memzones[k]; 
}

int RAcqMemZoneMgr::FindMemZoneId(MemZaction act)
{
  int rid = -1;
  if (stop_) return rid;
  if ((act != MemZA_Fill) && (act != MemZA_Save) && (act != MemZA_Proc)) return rid;
  mex.lock();
  while ((rid < 0)&&(!stop_)) {
    switch (act) {
  	  case MemZA_Fill:
  	    for(int k=0; k<NbZones(); k++) {
  	      if ((states[k].act == MemZA_None) && 
  	          ((states[k].stat == MemZS_Free)||(states[k].stat & MemZS_Saved)) ) 
  	            rid = k; break; 
  	    }
  	    if (rid >= 0) { states[rid].act = MemZA_Fill; states[rid].stat = MemZS_Free; }
  	  break;
  	  case MemZA_Save:
  	    for(int k=0; k<NbZones(); k++) {
  	      if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
  	          !(states[k].stat & MemZS_Saved) )  rid = k; break; 
  	    }
  	    if (rid >= 0) states[rid].act = MemZA_Save; 
  	  break;
  	  case MemZA_Proc:
  	    for(int k=0; k<NbZones(); k++) {
  	      if ((states[k].act == MemZA_None) && (states[k].stat & MemZS_Filled) && 
  	          !(states[k].stat & MemZS_Proc) )  rid = k; break; 
  	    }
  	    if (rid >= 0) states[rid].act = MemZA_Proc;   	      	  
  	  break;
    }
    if (rid < 0) mex.wait();
  }
  mex.unlock();
  return rid;
}

int RAcqMemZoneMgr::FreeMemZone(int id, MemZStatus st)
{
  if ((id < 0) || (id >= states.size()))  return 1;
  int rc = 0;
  mex.lock();
  switch (st) {
  	case MemZS_Free :
  	  states[id].stat = MemZS_Free; 
  	  states[id].act = MemZA_None;
  	break;
  	case MemZS_Filled :
  	  if (states[id].act != MemZA_Fill)  rc = 2;
  	  else states[id].nbact[0]++;
  	  states[id].stat |= MemZS_Filled; 
  	  states[id].act = MemZA_None;
  	break;
  	case MemZS_Saved :
  	  if (states[id].act != MemZA_Save)  rc = 4;
  	  else states[id].nbact[1]++;  	  
  	  states[id].stat |= MemZS_Saved; 
  	  states[id].act = MemZA_None;
  	break;
  	case MemZS_Proc :
  	  if (states[id].act != MemZA_Proc)  rc = 8;
  	  else states[id].nbact[2]++;  	  
  	  states[id].stat |= MemZS_Proc; 
  	  states[id].act = MemZA_None;
  	break;
  	default :
  	  rc = 16;
  	  states[id].stat = MemZS_Free; 
  	  states[id].act = MemZA_None;
  	break;
  }
  mex.unlock();
  mex.broadcast();
  return rc;
}

/*  MIS en inline 
Byte* RAcqMemZoneMgr::GetMemZone(int id)
{
  if ((id < 0) || (id >= memzones.size()))  return NULL;
  return memzones[id];
}
*/
ostream& RAcqMemZoneMgr::Print(ostream& os)
{
  os << "RAcqMemZoneMgr::Print() NbZones=" << NbZones() << " PaqSize()=" << PaqSize()
     << " NbPaquets()=" << NbPaquets() << " ZoneSize()=" << ZoneSize() << endl;
  for(int k=0; k<states.size(); k++) 
    os << " [" << k << "] Act=" << states[k].act << " Stat=" << states[k].stat 
       << " NbAct[0..2]=" << states[k].nbact[0] << "," << states[k].nbact[1]
       << "," << states[k].nbact[2] << endl; 	
  return os;   
}

void RAcqMemZoneMgr::Stop()
{
  stop_ = true;
  mex.broadcast();
}
