#ifndef  RACQUMEM_H_SEEN
#define  RACQUMEM_H_SEEN

//----------------------------------------------------------------
// ---- classes de gestion memoire pour acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------


#include "machdefs.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"

#include "brtypes.h"

using namespace std;

// Structure de gestion utilisee par la classe RAcqMemMgr
typedef struct {
  uint_4 act;
  uint_4 stat;
  uint_4 nbact[3]; 
//  int tid;
} St_MemZ;

enum MemZStatus { MemZS_Free=0, MemZS_Filled=1, MemZS_Saved=2, MemZS_Proc=4 };
enum MemZaction { MemZA_None=0, MemZA_Fill=1, MemZA_Save=2, MemZA_Proc=4};

// -------------------------------------------------------------------
// Structure de gestion de zones memoire partagee (des vecteurs) entre
// threads - qui doivent operer successivement sur les vecteurs
// -------------------------------------------------------------------
class RAcqMemZoneMgr {
public:
// Constructeur, nz=Nb de zones, np=Nb de paquets/zone , psz=taille de paquet
  RAcqMemZoneMgr(uint_4 nz, uint_4 np=1000, uint_4 psz=4096);
  ~RAcqMemZoneMgr();
  
  // Retourne le nombre de zones memoire
  inline uint_4 NbZones() { return nzones; }
  // Retourne la taille de paquet
  inline uint_4 PaqSize() { return paqsz; }
  // Retourne le nb de paquets dans une zone
  inline uint_4 NbPaquets() { return npaq; }
  // Retourne la taille totale d'une zone 
  inline uint_4 ZoneSize() { return npaq*paqsz; }
  
  // Retourne un MemZone disponible pour une action specifique
  int FindMemZoneId(MemZaction act);
  // Libere une zone memoire en marquant son etat
  int FreeMemZone(int id, MemZStatus st);
  // Retourne le pointeur de la zone numero k
  inline Byte* GetMemZone(int id)  {
    if ((id < 0) || (id >= memzones.size()))  return NULL;
    return memzones[id];  
    }
  
  ostream& Print(ostream& os);
  void Stop(); 
        
protected:
  // ... variables membres
  ZMutex mex;   
  uint_4 nzones, npaq, paqsz;
  vector< Byte* > memzones;
  vector< St_MemZ > states; 
  bool stop_;
};




#endif
