#include "racquproc.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>

#include "pexceptions.h"
#include "tvector.h"
#include "fioarr.h"
#include "timestamp.h"
#include "fftpserver.h"
#include "fftwserver.h"

#include "FFTW/fftw3.h"


#include "pciewrap.h"
#include "brpaqu.h"
#include "minifits.h"


//-------------------------------------------------------
// Classe thread de traitement 
//-------------------------------------------------------

DataProc::DataProc(RAcqMemZoneMgr& mem, string& path, uint_4 nmean, uint_4 nmax)
  :  memgr(mem) 
{
  nmax_ = nmax;	
  nmean_ = nmean;
  stop_ = false;	
  path_ = path;	
}

inline r_4 Zmod2(complex<r_4> z) 
{ return (z.real()*z.real()+z.imag()*z.imag()); }

void DataProc::run()
{
  	
  setRC(1);	
  try {
    TimeStamp ts; 
    cout << " DataProc::run() - Starting " << ts << " NMaxMemZones=" << nmax_ << endl;	
    char fname[512];
    sprintf(fname,"%s/proc.log",path_.c_str());
    ofstream filog(fname);
    filog << " DataProc::run() - starting log file " << ts << endl;		       

// Initialisation pour clcul FFT 
    TVector< complex<r_4> > cfour;  // composant TF
    uint_4 paqsz = memgr.PaqSize();
    BRPaquet pq(NULL, NULL, paqsz); 
    TVector<r_4> vx(pq.DataSize());
    vx = (r_4)(0.);
    FFTPackServer ffts;
    ffts.FFTForward(vx, cfour);
    TVector<r_4> spectre;
    spectre.ReSize(cfour.Size());
    
    fftwf_plan plan = fftwf_plan_dft_r2c_1d(pq.DataSize(), vx.Data(), 
	  			       (fftwf_complex *)cfour.Data(), FFTW_ESTIMATE); 

    uint_4 ifile = 0;  			        
    for (uint_4 kmz=0; kmz<nmax_; kmz++) {
      int mid = memgr.FindMemZoneId(MemZA_Proc);
      Byte* buff = memgr.GetMemZone(mid);
      if (buff == NULL) {
  	cout << " DataProc::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
  	setRC(2);	
  	return;	
      }
      BRPaquet paq0(NULL, buff, paqsz); 
      uint_4 nzm = 0;
      for(uint_4 i=0; i<memgr.NbPaquets(); i++) {
  	BRPaquet paq(NULL, buff+i*paqsz, paqsz); 
  	Byte min = 255;
  	Byte max = 0;
  	    
  	for(sa_size_t j=0; j<vx.Size(); j++) 
  	  vx(j) = (r_4)(*(paq.Data()+j));
  	fftwf_execute(plan); 
        //    ffts_.FFTForward(vx, cfour_);
        for(sa_size_t j=0; j<spectre.Size(); j++) 
          spectre(j) += Zmod2(cfour(j)); 
        nzm++;
      }
      if (nzm >= nmean_) {
        spectre /= (r_4)(nzm);
    	sprintf(fname,"%s/spectre%d.ppf",path_.c_str(),(int)ifile);
        POutPersist po(fname);
        po << spectre; 
        spectre = (r_4)(0.);
        nzm = 0;  ifile++; 
        ts.SetNow();
        filog << ts << " :  proc file  " << fname << endl;		       
        cout << " DataProc::run() " << ts << " : created file  " << fname << endl;
      }
      
      memgr.FreeMemZone(mid, MemZS_Proc);
    }
  }
  catch (PException& exc) {
    cout << " DataProc::run()/catched PException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " DataProc::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   
