//----------------------------------------------------------------
// ---- classes de threads pour lecture (transfert DMA) 
//      et ecriture disque pour acquisition   BAORadio       -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------

#include "racqurw.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>

#include "pexceptions.h"
#include "timestamp.h"


#include "pciewrap.h"
#include "brpaqu.h"
#include "minifits.h"


//-------------------------------------------------------
// Classe thread de lecture PCI-Express
//-------------------------------------------------------

PCIEReader::PCIEReader(RAcqMemZoneMgr& mem, uint_4 nmax)
  :  memgr(mem)
{
  nmax_ = nmax;		
  stop_ = false;	
}

void PCIEReader::run()
{
  cout << " PCIEReader::run() - Starting , NMaxMemZones=" << nmax_ << endl;	
  setRC(1);	
  PCIEWrapper pciw;	
  uint_4 paqsz = memgr.PaqSize();
  for (uint_4 kmz=0; kmz<nmax_; kmz++) {
    int mid = memgr.FindMemZoneId(MemZA_Fill);
    Byte* buff = memgr.GetMemZone(mid);
    if (buff == NULL) {
      cout << " PCIEReader::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
      setRC(2);	  	  
      return;	
    }
    for(uint_4 i=0; i<memgr.NbPaquets(); i++) {
      while(pciw.NBytesToRead() < 1)  usleep(5);
      pciw.Read(buff+i*paqsz,paqsz); 	
    }
    memgr.FreeMemZone(mid, MemZS_Filled);
  }	
  setRC(0);
  return;
}



//-------------------------------------------------------
// Classe thread de sauvegarde sur fichiers
//-------------------------------------------------------

DataSaver::DataSaver(RAcqMemZoneMgr& mem, string& path, uint_4 nmax)
  :  memgr(mem) 
{
  nmax_ = nmax;	
  stop_ = false;	
  path_ = path;	
}

void DataSaver::run()
{
  setRC(1);	
  try {
    TimeStamp ts; 
    cout << " DataSaver::run() - Starting " << ts << " NMaxMemZones=" << nmax_ << endl;	
    char fname[512];
    sprintf(fname,"%s/saver.log",path_.c_str());
    ofstream filog(fname);
    filog << " DataProc::run() - starting log file " << ts << endl;		       

    uint_4 paqsz = memgr.PaqSize();
    for (uint_4 kmz=0; kmz<nmax_; kmz++) {
      int mid = memgr.FindMemZoneId(MemZA_Save);
      Byte* buff = memgr.GetMemZone(mid);
      if (buff == NULL) {
  	cout << " DataSaver::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
  	setRC(2);	
  	return;	
      }
      sprintf(fname,"%s/signal%d.fits",path_.c_str(),(int)kmz);
      MiniFITSFile mff(fname,MF_Write);
      BRPaquet paq0(NULL, buff, paqsz); 
      mff.setDTypeNaxis(MF_Byte, paq0.DataSize(), memgr.NbPaquets());
      for(uint_4 i=0; i<memgr.NbPaquets(); i++) {
  	BRPaquet paq(NULL, buff+i*paqsz, paqsz); 
  	mff.WriteB(paq.Data(), paq.DataSize());
      }
      filog << ts << " : created data file  " << fname << endl;		       
      cout << " DataSaver::run() " << ts << " : created data file  " << fname << endl;
      memgr.FreeMemZone(mid, MemZS_Saved);
    }
  }
  catch (MiniFITSException& exc) {
    cout << " DataSaver::run()/catched MiniFITSException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " DataSaver::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   


