#ifndef  RACQURW_H_SEEN
#define  RACQURW_H_SEEN

//----------------------------------------------------------------
// ---- classes de threads pour lecture (transfert DMA) 
//      et ecriture disque pour acquisition   BAORadio       -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//----------------------------------------------------------------

#include "racqumem.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"

#include "brtypes.h"

using namespace std;



//-------------------------------------------------------
// Classe thread de lecture PCI-Express
//-------------------------------------------------------

class PCIEReader : public ZThread {
public:
  PCIEReader(RAcqMemZoneMgr& mem, uint_4 nmax=100);	
  virtual void run(); 
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  bool stop_;  
};

//-------------------------------------------------------
// Classe thread de sauvegarde sur fichiers
//-------------------------------------------------------

class DataSaver : public ZThread {
public:	
  DataSaver(RAcqMemZoneMgr& mem, string& path, uint_4 nmax=100);
  virtual void run(); 
  inline void STOP() { stop_ = true; }	
protected:
  RAcqMemZoneMgr& memgr;
  uint_4 nmax_;  // Nombre maxi de blocs MemZone traites
  bool stop_;  
  string path_;  
};


#endif
