// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <string>

#include "pexceptions.h"  // les exceptions SOPHYA

// Include sophya des tableaux
#include "tvector.h" // Pour l'utilisation des classes TArray, TMatrix , TVector
#include "fioarr.h"  // Pour IO PPF TArray
#include "sopemtx.h"
#include "matharr.h"
#include "tarrinit.h" // Pour l'utilisation des classes TArray, TMatrix , TVecto
// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

// ---- ENTETE classe BRPaquet 
#include "brpaqu.h"

int main(int narg, char* arg[])
{
	/*
  cout << " sizeof(UInt32)= " << sizeof(UInt32) << endl;
    cout << " sizeof(UInt64)= " << sizeof(UInt64) << endl;
 UInt64 i1,i2,i3; 
 i1 = 0xFF000000; 
 i2 = i1*256; 
 i3 = 20000000000L;
 cout << " i1= " << i1 << " i2 = " << i2 << " 0x" << hex << i2 
      << dec << " i3=" << i3 << " 0x"<< hex << i3 << dec << endl;
      */
      
  if (narg < 3) {
    cout << "tbrpaq.cc/Erreur arg: tbrpaq paqsz filename [neltsprint=8] [OutPPFFileName]" << endl;
    return 1;
  }

  // Sophya modules initialization
  TArrayInitiator  _inia;
  //------- AU LIEU DE ------>  SophyaInit();

  InitTim();   // Initializing the CPU timer

  int paqsz = atoi(arg[1]);
  string filename = arg[2];
  int nelt = 8;
  if (narg>3) nelt = atoi(arg[3]);

  cout << " tbrpaq : reading from file " << filename
       << " PaqSize=" << paqsz << endl;
  FILE* fip = NULL;
  fip = fopen(filename.c_str(),"rb");
  if (fip == NULL) {
    cout << " tbrpaq : ERROR opening file" << endl;
    return 2;
  }
  Byte * src = new Byte[paqsz];
  Byte * dst = new Byte[paqsz];

  fread(src, 1, (size_t)(paqsz), fip);
  fclose(fip);

  cout << " tbrpaq : Creating BRPaquet(src,dst,paqsz) ... " << endl;

  BRPaquet paq(src, dst, paqsz);
  cout << " tbrpaq : Appel paq.Print(cout) ... " << endl;
  paq.Print(cout, nelt, true);

  if (narg>4) {
    string outppf = arg[4];
    cout << " tbrpaq: Creating OutPPF file from data to file" << outppf << endl;
    TVector<int_2> vd(paq.DataSize());
    for(int k=0; k<paq.DataSize(); k++)  vd(k) = (int_2)(*(paq.Data()+k));
    POutPersist po(outppf);
    po << vd; 
  }
  // Cleanup
  delete[] src;
  delete[] dst;

  PrtTim("FIN tbrpaq.cc");
  cout << " ---------- FIN tbrpaq -----------" << endl;
  return 0;
}
