// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <typeinfo>
#include <string>


#include "pexceptions.h"  // les exceptions SOPHYA
// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

// #include "array.h"

#include "pciewrap.h"
int main(int narg, char* arg[])
{

  if (narg < 2) {
    cout << "tpciew.cc/Usage: tpciew nread [prtlev=0] " << endl;
    cout << "     nread<=0 --> PCIEWException " << endl;
    return 1;
  }

  int NRead = atoi(arg[1]);
  int PrtLev = 0;
  if (narg > 2) PrtLev = atoi(arg[2]);
  // Sophya modules initialization
  //   TArrayInitiator  _inia;
  //------- AU LIEU DE ------>  SophyaInit();  

  InitTim();   // Initializing the CPU timer

  cout << " ---------- tpciew.cc Start --- NRead= " << NRead << " PrtLev=" << PrtLev << endl;
  int rc = 0;
  try {
#define SZ  4096  
    uint_1 data[SZ];
    PCIEWrapper pciw;
    if (NRead <= 0) {
      uint_4 nbytes = 1;
      while(nbytes > 0)  nbytes = pciw.NBytesToRead();
      pciw.Read(data, SZ);
    }
    else {
      for(int k=0; k<NRead; k++) {
        uint_4 nbytes = 0;
        while(nbytes <= 0) {
          usleep(1000);
          nbytes = pciw.NBytesToRead();
        }
        uint_4 nbok = pciw.Read(data, SZ);
        cout << "---[" << k << "] pciw.Read(data, SZ=" << SZ << ") --> NBytesOk=" << nbok << endl;
        if (PrtLev > 0) {
          cout << "data[] : ";
          for(int j=0; j<PrtLev*5; j++) cout << " , " << (uint_4)data[j];
          cout << endl;
        }
      }
    }
  }
  catch (PCIEWException& exc) {
    cerr << " tpciew.cc catched PCIEWException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (PThrowable& exc) {
    cerr << " tpciew.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n tpciew.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " tpciew.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> tpciew.cc ------- FIN ----------- RC=" << rc << endl;
  PrtTim("FIN tpciew.cc");
  return rc;

}
