
// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <string>


// include mini-fits lib 
#include "minifits.h"

int main(int narg, char* arg[])
{
  if (narg < 2) {
    cout << " Usage: tstrdfits file1.fits [file2.fits ...] " << endl;
    return 1;
  }
  cout << " ---------- tstrdfits.cc Start ------------- " << endl;
  int rc = 0;
  try {
    for(int ifile=1; ifile<narg; ifile++) {
      string ffname = arg[ifile];
// -------------- Lecture de bytes      
      cout << ifile <<"-Ouverture/lecture fichier " << ffname << endl;
      MiniFITSFile mff(ffname, MF_Read);
      cout << "... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
	   << " NAxis2=" << mff.NAxis2() << endl;
      if (mff.DataType() != MF_Byte) {
        cout << " PB : DataType!=MF_Byte --> skipping " << endl;
      }
      size_t sx = mff.NAxis1(); 
      size_t sy = mff.NAxis2();
      Byte* data = new Byte[sx];
      for(int j=0; j<sy; j++) {
	mff.ReadB(data, sx, j*sx);
	cout << " j=" << j << " data[0...3]=" << (int)data[0] << " , " 
	     << (int)data[1] << " , " <<  (int)data[2] << endl;
      }
      cout << "---- FIN lecture " << ffname << endl;
    }   
  }
  catch (MiniFITSException& exc) {
    cerr << " tstrdfits.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (std::exception& sex) {
    cerr << "\n tstrdfits.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " tstrdfits.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> tstrdfits.cc ------- FIN ----------- RC=" << rc << endl;
  return rc;

}
