#include "minifits.h"

// #include <iostream>

#define MFITSHLEN 2880

MiniFITSFile::MiniFITSFile()
{
  Init();
}

MiniFITSFile::MiniFITSFile(string const & nom, MiniFITS_Mode rwm)
{
  Init();
  Open(nom, rwm);
}

MiniFITSFile::MiniFITSFile(const char* nom, MiniFITS_Mode rwm)
{
  Init();
  Open(nom, rwm);
}


MiniFITSFile::~MiniFITSFile()
{
  Close();
  delete[] header;
}

void MiniFITSFile::Init()
{
  fip = NULL;
  rwmode = MF_Read;
  dtype = MF_Byte;
  nax1 = 1;
  nax2 = 1; 
  totwsz = 0;
  header = new char[MFITSHLEN];

}

void MiniFITSFile::Open(const char* nom, MiniFITS_Mode rwm)
{
  if (fip != NULL) throw MiniFITSException("MiniFITSFile::Open() - fip != NULL");
  if (rwm == MF_Write) {
    FillHeader();
    fip = fopen(nom, "w");
    if (fip == NULL) 
      throw MiniFITSException("MiniFITSFile::Open()/ failed fopen() for write");
    fwrite(header, 1, MFITSHLEN, fip);
    rwmode = MF_Write;
  }
  else {
    fip = fopen(nom, "r");
    if (fip == NULL) 
      throw MiniFITSException("MiniFITSFile::Open()/ failed fopen() for read");
    fread(header, 1, MFITSHLEN, fip);
    DecodeHeader();
    rwmode = MF_Read;
  }
  return;
}

void MiniFITSFile::Close()
{
  if (fip) { 
  	if (rwmode == MF_Write)  {  
  	  // on remplit avec des zeros pour avoir une longueur multiple de 2880	
  	  size_t padsz = MFITSHLEN-(totwsz%MFITSHLEN);
  	  for(size_t k=0; k<padsz; k++) header[k]=0;
  	  fwrite(header, 1, padsz, fip);
  	  // On reecrit l'entete 
  	  FillHeader();
  	  fseek(fip, 0, SEEK_SET);
  	  fwrite(header, 1, MFITSHLEN, fip);
  	}	
  	fclose(fip);
  }
  fip = NULL;
  return;
}

void MiniFITSFile::setDTypeNaxis(MiniFITS_DT dt, size_t na1, size_t na2)
{
  // Interdit si fichier ouvert en lecture ...
  if ((fip!=NULL)&&(rwmode == MF_Read))  
     throw MiniFITSException("MiniFITSFile::setDTypeNaxis()/Error ReadOnly file");

  dtype = dt;
  nax1 = na1; 
  nax2 = na2;
}

string MiniFITSFile::DataTypeToString()
{
  if (dtype == MF_Byte) return "MF_Byte";
  else if (dtype == MF_Int16) return "MF_Int16";
  else if (dtype == MF_Float32) return "MF_Float32";
  else return "Unknown??";
}

int MiniFITSFile::Write(void* data, size_t sz)
{
  fwrite(data, 1, sz, fip);
  totwsz += sz;
  return 0;
}

int MiniFITSFile::Read(void* data, size_t sz, size_t offset)
{
  fseek(fip, offset+MFITSHLEN, SEEK_SET);
  fread(data, 1, sz, fip);
  return 0;
}

void MiniFITSFile::FillHeader()
{
  for(int i=0; i<MFITSHLEN; i++)  header[i]=' ';
  strcpy(header, "SIMPLE  =                    T / file does conform to FITS standard");
  header[strlen(header)] = ' ';
  int bpix = 8;
  if (dtype == MF_Byte) bpix = 8;
  else if (dtype == MF_Int16) bpix = 16;
  else if (dtype == MF_Float32) bpix = -32;
  char * buff = header+80;
  sprintf(buff, "BITPIX  = %20d /   number of bits per data pixel", bpix);
  buff[strlen(buff)] = ' ';
  buff = header+160;
  strcpy(buff, "NAXIS   =                    2 / number of data axes");
  buff[strlen(buff)] = ' ';
  buff = header+240;
  sprintf(buff, "NAXIS1  = %20ld /   number of bits per data pixel", (long)nax1);
  buff[strlen(buff)] = ' ';
  buff = header+320;
  sprintf(buff, "NAXIS2  = %20ld /   number of bits per data pixel", (long)nax2);
  buff[strlen(buff)] = ' ';
  buff = header+400;
  strcpy(buff,"COMMENT  BAO-Radio / MiniFITSFile ");
  buff[strlen(buff)] = ' ';
  buff = header+480;
  strcpy(buff,"END");
  buff[strlen(buff)] = ' ';

  return;
}


void MiniFITSFile::DecodeHeader()
{
  // AMELIORER le decodage de l'entete, remplissage dtype, nax1, nax2
  char * buff = header;
  if (strncmp(buff, "SIMPLE  =", 9) != 0) 
     throw MiniFITSException("MiniFITSFile::DecodeHeader()/Error - NO SIMPLE keyword");
  bool fgokt=false;
  bool fgok1=false;
  bool fgok2=false;
  for(int kh=80; kh<2800; kh+=80) {
  	buff = header+kh;
  	if (strncmp(buff, "NAXIS1  =", 9) == 0)  {
  	  nax1 = atol(buff+10);
  	  fgok1 = true;
//  	  cout << " FOUND : NAXIS1= " << nax1 << endl;
  	} 
  	else if (strncmp(buff, "NAXIS2  =", 9) == 0)  {
  	  nax2 = atol(buff+10);
  	  fgok2 = true;
//  	  cout << " FOUND : NAXIS2= " << nax2 << endl;  	  
  	} 
  	else if (strncmp(buff, "BITPIX  =", 9) == 0)  {
  	  int bpix = atoi(buff+10);
  	  fgokt = true;
  	  if (bpix == 8)  dtype = MF_Byte;
  	  else if (bpix == 16)  dtype = MF_Int16;
  	  else if (bpix == -32)  dtype = MF_Float32;
  	  else fgokt = false;
//  	  cout << " FOUND : bpix= " << bpix << endl;  	  	  
  	} 
  }
  if (!(fgok1&&fgok2&&fgokt))  
     throw MiniFITSException("MiniFITSFile::DecodeHeader()/Error- Missing/wrong NAXIS1/2,BITPIX");
  return;
}

