#include "sockrawstream.h"
#include "sopnamsp.h"
#include "pexceptions.h"

/*!
   \class SOPHYA::RawInOutSocketStream
   \ingroup SysTools
   This class implements the interface defined by RawInOutStream 
   over a socket (read and write operations).
   It is mainly intended to be used by PPF In/Out streams.
*/


/* --Methode-- */
RawInOutSocketStream::RawInOutSocketStream(Socket &skt, size_t rwb_size)
  : RawInOutStream() , _skt(skt)
{
  if (rwb_size < 1) rwb_size = 256;
  _rdbuff.buff = new char[rwb_size];
  _rdbuff.sz = rwb_size;
  _rdbuff.cpos = rwb_size;

  _wrbuff.buff = new char[rwb_size];
  _wrbuff.sz = rwb_size;
  _wrbuff.cpos = 0;
  
}

/* --Methode-- */
RawInOutSocketStream::~RawInOutSocketStream()
{
  //DBG  cout << " ---- DESTRUCTEUR ---- ~RawInOutSocketStream() " << endl;
  if (_wrbuff.cpos > 0) {
    for (size_t k= _wrbuff.cpos; k<_wrbuff.sz; k++)
      _wrbuff.buff[k] = '\0';
    _wrbuff.cpos = _wrbuff.sz;
    SendBuffer();
  }
  delete [] _rdbuff.buff;
  delete [] _wrbuff.buff;
}

/* --Methode-- */
size_t RawInOutSocketStream::CopyToSendBuffer(const char* s, size_t n)
{

  size_t len = _wrbuff.sz-_wrbuff.cpos;
  if (len > n) len = n;
  if ( (_wrbuff.cpos == 0) && (len == _wrbuff.sz) ) {
 //DBG   cout << "RawInOutSocketStream::CopyToSend/DBG-1 - n=" 
//DBG	 << n << " len=" << len << endl;
    Send(s, len);
  }
  else {
 //DBG   cout << "RawInOutSocketStream::CopyToSend/DBG-2 - n=" 
//DBG	 << n << " len=" << len << " cpos=" << _wrbuff.cpos << endl;
    memcpy(_wrbuff.buff+_wrbuff.cpos, s, len);
    //DBG    cout << " memcpy OK - cpos= " << _wrbuff.cpos << endl;
    _wrbuff.cpos += len;
    if (_wrbuff.cpos == _wrbuff.sz)  SendBuffer();
  }
  return len;
}

/* --Methode-- */
size_t RawInOutSocketStream::CopyFromRecvBuffer(char* s, size_t n)
{
  if ( (_rdbuff.cpos == _rdbuff.sz) && ( n >= _rdbuff.sz)) {
    size_t len = _rdbuff.sz;
  //DBG  cout << "RawInOutSocketStream::CopyFromRecv/DBG-1 - n=" << n 
//DBG	 << " len=" << len << endl;
    Receive(s, len);
    return len;
  }
  else {
//DBG    cout << "RawInOutSocketStream::CopyFromRecv/DBG-2 - n=" << n << endl;
    if (_rdbuff.cpos == _rdbuff.sz)  ReceiveBuffer();
    size_t len = _rdbuff.sz-_rdbuff.cpos;
    if (len > n) len = n;
    memcpy(s, _rdbuff.buff+_rdbuff.cpos, len);
    _rdbuff.cpos += len;
    return len;
  }
}

/* --Methode-- */
void RawInOutSocketStream::SendBuffer()
{
//DBG  cout << "RawInOutSocketStream::SendBuffer/DBG - cpos=" 
 //DBG      <<  _wrbuff.cpos << " sz=" << _wrbuff.sz << endl;
  //  if (_wrbuff.cpos != _wrbuff.sz)  return;
  Send(_wrbuff.buff, _wrbuff.sz);
  _wrbuff.cpos = 0;
}

/* --Methode-- */
void RawInOutSocketStream::ReceiveBuffer()
{
  //  if (_rdbuff.cpos != _rdbuff.sz)  return;
 //DBG cout << "RawInOutSocketStream::ReceiveBuffer/DBG - cpos=" 
 //DBG      <<  _rdbuff.cpos << " sz=" << _rdbuff.sz << endl;
  Receive(_rdbuff.buff, _rdbuff.sz);
  _rdbuff.cpos = 0;
  
}

/* --Methode-- */
size_t RawInOutSocketStream::Send(const char* s, size_t n)
{
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = _skt.Send(s+nst, n-nst);
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) 
    throw IOExc("RawInOutSocketStream::Send()/write() Error nwrite < n");
  return nst;
}

/* --Methode-- */
size_t RawInOutSocketStream::Receive(char* s, size_t n)
{
  size_t  nst = 0;
  int ntry = 0;
  while (nst < n) {
    size_t ns = _skt.Receive(s+nst, n-nst);
    ntry++;
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) {
    cout << "  RawInOutSocketStream::Receive() / Pb ! ntry=" << ntry
	 << " nst=" << nst << " n=" << n << endl;
    throw IOExc("RawInOutSocketStream::Receive/read() Error nread < n");
  }
  return nst;
}

int_8 RawInOutSocketStream::tellg()
{
  return _totnrd;
}

/* --Methode-- */
RawInOutStream& RawInOutSocketStream::read(char* s, uint_8 n)
{
//DBG  cout << "RawInOutSocketStream::read()/DBG - n=" << n << endl;
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = CopyFromRecvBuffer(s+nst, n-nst);
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) 
    throw IOExc("RawInOutSocketStream::read() Error nread < n");
  _totnrd += n;
  return *this;
}

/* --Methode-- */
int_8 RawInOutSocketStream::tellp()
{
  return _totnwr;
}

/* --Methode-- */
RawInOutStream& RawInOutSocketStream::write(const char* s, uint_8 n)
{
//DBG  cout << "RawInOutSocketStream::write()/DBG - n=" << n << endl;
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = CopyToSendBuffer(s+nst, n-nst);
    if (ns < 1)  break;
    nst += ns;
  }
 //DBG cout << "RawInOutSocketStream::write()/DBG ---> nst=" << nst << endl;
  
  if ( nst < n) 
    throw IOExc("RawInOutSocketStream::write() Error nwrite < n");
  _totnwr += n;
  return *this;
}


