// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

// include standard c/c++
#include <math.h>
#include <stdio.h>

#include <iostream>
#include <typeinfo>
#include <string>


#include "pexceptions.h"  // les exceptions SOPHYA

// Include sophya des tableaux 
#include "tvector.h" // Pour l'utilisation des classes TArray, TMatrix , TVector
#include "fioarr.h"  // Pour IO PPF TArray
#include "sopemtx.h"
#include "matharr.h"  
#include "tarrinit.h" // Pour l'utilisation des classes TArray, TMatrix , TVector

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

// include mini-fits lib 
#include "minifits.h"

int main(int narg, char* arg[])
{
  // Sophya modules initialization
  TArrayInitiator  _inia;
  //------- AU LIEU DE ------>  SophyaInit();  

  InitTim();   // Initializing the CPU timer

  cout << " ---------- tstminifits.cc Start ------------- " << endl;
  int rc = 0;
  try {
    {
    cout << "1/ Creation tableau " << endl;
    size_t sx = 300;
    size_t sy = 200; 
    TArray<int_2> ta(sx, sy);
    TArray<r_4> arr(sx, sy);
    ta = RegularSequence(0.,0.5);
    ta.Show();
    arr = RandomSequence(RandomSequence::Gaussian, 510.,30.); 
    arr.Show();
    cout << "2/ ecriture tableaux ta (int_2) arr (r_4) ds tmf.ppf " << endl;
    POutPersist po("tmf.ppf");
    po << ta << arr;
    cout << "3/ ecriture tableau ds tmf.fits " << endl;
    {
    MiniFITSFile mff;
    mff.setDTypeNaxis(MF_Float32, sx, sy);
    mff.Open("tmf.fits", MF_Write);
    mff.WriteI(ta.Data(), sx*sy);
    }
    cout << "3.b/ ecriture tableau arr (r_4) ds tmf2.fits " << endl;
    {
    MiniFITSFile mff;
    mff.setDTypeNaxis(MF_Int16, sx, sy);
    mff.Open("tmf2.fits", MF_Write);
    mff.WriteF(arr.Data(), sx*sy);
    }
    cout << "3.c/ FIN ecriture tableau ds tmf.fits " << endl;   
    }
//  --------------  Ecriture de bytes par morceaux 
    {
    cout << "4/ Creation tableau uint_1" << endl;
    size_t sx = 178; 
    size_t sy = 14;
    uint_1* data = new uint_1[sx];
    MiniFITSFile mff("tmfb.fits", MF_Write);

    for(int k=0; k<sy; k++) {
      for(int j=0; j<sx; j++) data[j] = (k%8)*3+j;
      mff.WriteB(data, sx);
    }
    mff.setDTypeNaxis(MF_Byte, sx, sy);
    delete [] data;
    cout << "5/ FIN ecriture tableau ds tmfb.fits " << endl;   
    }
// -------------- Lecture de bytes      
    {
    cout << "6/ Ouverture/lecture tmfb.fits" << endl;
    MiniFITSFile mff("tmfb.fits", MF_Read);
    cout << "6.b/ Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
    << " NAxis2=" << mff.NAxis2() << endl;
    size_t sx = mff.NAxis1(); 
    size_t sy = mff.NAxis2();
    uint_1* data = new uint_1[sx*sy];
    mff.ReadB(data, sx*sy);
    cout << "7/ FIN lecture depuis tmfb.fits " << endl;   
    TArray<int_2> ta(sx, sy);
    for(int k=0; k<sy; k++) 
      for(int j=0; j<sx; j++) ta(j, k) = (int_2)data[j+k*sx];
    POutPersist po("tmfb.ppf");
    po << ta;
    cout << "8/ FIN ecriture tableau ds tmfb.ppf " << endl; 
    delete[] data;
    }
  }
  catch (MiniFITSException& exc) {
    cerr << " tstminifits.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (PThrowable& exc) {
    cerr << " tstminifits.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n tstminifits.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " tstminifits.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> tstminifits.cc ------- FIN ----------- RC=" << rc << endl;
  PrtTim("FIN tstminifits.cc");
  return rc;

}
