#include "sopnamsp.h"
#include "machdefs.h"
#include <math.h>
#include <iostream>
#include <stdio.h>
#include <typeinfo>

// Pour 
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "pexceptions.h"  // les exceptions SOPHYA

#include "tvector.h" // Pour l'utilisation des classes TArray, TMatrix , TVector
#include "fioarr.h"  // Pour IO PPF TArray
#include "sopemtx.h"
#include "matharr.h"  

#include "fitsfile.h"     // Pour IO FITS TArray
#include "fitsarrhand.h"     // Pour IO FITS TArray


// Pour l'initialisation des modules  TArray , FitsIOServer 
#include "tarrinit.h"   
#include "fiosinit.h"     


#include "timing.h"
#include "ctimer.h"

//-----------------------------------------------------------

static sa_size_t SIZE = 25000;
static int NFILE = 10;

void tio_raw();
void tio_fraw();
void tio_ppf();
void tio_fits();

/* --------------------------------------------------------
  Programme de comparaison IO disk - manip BAO-Radio
  --------------------------------------------------------- */
   
int main(int narg, char* arg[])
{
  // Sophya modules initialization
  TArrayInitiator  _inia;
  FitsIOServerInitiator  _inif;
  //------- AU LIEU DE ------>  SophyaInit();  

  InitTim();   // Initializing the CPU timer

  if (narg < 2) {
    cout << "  Usage: traidio SEL [Size [NFile]] \n" 
	 << "    SEL = raw OU fraw OU ppf  OU fits \n"  
	 << "    Size : taille tableau (int_4) \n"
	 << "    NFile : Nb de fichiers \n" << endl;
    return 1;
  }
  string sel = arg[1];
  if (narg > 2)  SIZE = atol(arg[2]);
  if (narg > 3)  NFILE = atoi(arg[3]);
  cout << " ====== traidio : SEL=" << sel << " Size=" << SIZE << " NFile= " << NFILE << endl;
  int rc = 0;
  try {
    if (sel == "raw") tio_raw();
    else if (sel == "fraw") tio_fraw();
    else if (sel == "ppf") tio_ppf();
    else if (sel == "fits") tio_fits();
    else { rc = 2; cout << " traidio/erreur : SEL non valide" << endl;}
  }
  catch (PThrowable& exc) {
    cerr << " traidio.cc catched Exception " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (std::exception& sex) {
    cerr << "\n traidio.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " traidio.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> traidio.cc ------- FIN ----------- RC=" << rc << endl;
  PrtTim("FIN traidio.cc");
  return rc;
}




void tio_raw()
{
  Timer tm("traidio/tio_raw");
  TArray<int_4> ia(SIZE,0,0);
  ia = RegularSequence();
  tm.Split("tio_raw/ia-OK");
  char flnm[128];
  for(int i=0; i<NFILE; i++) {
    sprintf(flnm, "traid%d.raw",i);
    string ss = flnm;
    cout << i << "-----> Creating file " << flnm << endl;
    int fid = -1;
    fid = open(flnm,O_CREAT|O_WRONLY,S_IRUSR|S_IWUSR);
    if (fid < 0) {
      cout << i << " ERROR !!!! creating file " << flnm << endl;
      continue;
    }
    write(fid, ia.Data(), SIZE*sizeof(int_4));
    close(fid);
    tm.Split("tio_raw/Write-Done");
  }
}

void tio_fraw()
{
  Timer tm("traidio/tio_fraw");
  TArray<int_4> ia(SIZE,0,0);
  ia = RegularSequence();
  tm.Split("tio_fraw/ia-OK");
  char flnm[128];
  for(int i=0; i<NFILE; i++) {
    sprintf(flnm, "traid%d.fraw",i);
    string ss = flnm;
    cout << i << "-----> Creating file " << flnm << endl;
    FILE* fip = NULL;
    fip = fopen(flnm,"w");
    if (fip == NULL) {
      cout << i << " ERROR !!!! creating file " << flnm << endl;
      continue;
    }
    fwrite(ia.Data(), SIZE, sizeof(int_4), fip);
    fclose(fip);
    tm.Split("tio_fraw/Write-Done");
  }
}

void tio_ppf()
{
  Timer tm("traidio/tio_ppf");
  TArray<int_4> ia(SIZE,0,0);
  ia = RegularSequence();
  tm.Split("tio_ppf/ia-OK");
  char flnm[128];
  for(int i=0; i<NFILE; i++) {
    sprintf(flnm, "traid%d.ppf",i);
    string ss = flnm;
    cout << i << "-----> Creating file " << flnm << endl;
    POutPersist po(ss);
    po << ia;
    tm.Split("tio_ppf/Write-Done");
  }
}

void tio_fits()
{
  Timer tm("traidio/tio_fits");
  TArray<int_4> ia(SIZE,0,0);
  ia = RegularSequence();
  tm.Split("tio_fits/ia-OK");
  char flnm[128];
  for(int i=0; i<NFILE; i++) {
    sprintf(flnm, "!traid%d.fits",i);
    string ss = flnm;
    cout << i << "-----> Creating file " << flnm << endl;
    FitsOutFile fo(ss);
    fo << ia;
    tm.Split("tio_fits/Write-Done");
  }
}
