// This may look like C code, but it is really -*- C++ -*-

#ifndef SOCKRAWSTREAM_H_SEEN
#define SOCKRAWSTREAM_H_SEEN

// Classe de flot brut sur socket - pour utilisation par les streams PPersist
// R. Ansari      LAL IN2P3/CNRS  11/2005

#include "machdefs.h"
#include "rawstream.h"
#include "swrapsock.h"


namespace SOPHYA {

// Input flow over a socket
class RawInOutSocketStream : public RawInOutStream {
public:
                      RawInOutSocketStream(Socket& skt, size_t npaq_buff=16);
  virtual             ~RawInOutSocketStream();

  // Lecture 
  virtual int_8       tellg();
  virtual RawInOutStream& read(char* s, uint_8 n); 
  // Ecriture 
  virtual int_8       tellp();
  virtual RawInOutStream& write(const char* s, uint_8 n);

protected:
  size_t CopyToSendBuffer(const char* s, size_t n);
  size_t CopyFromRecvBuffer(char* s, size_t n);
  void SendBuffer();
  void ReceiveBuffer();

  size_t Send(const char* s, size_t n);
  size_t Receive(char* s, size_t n);

  Socket & _skt;
  struct SRWBuff { char* buff; size_t sz, cpos; };
  SRWBuff _rdbuff;
  SRWBuff _wrbuff;
  size_t _totnwr;
  size_t _totnrd;
};


} // namespace SOPHYA

#endif
