// This may look like C code, but it is really -*- C++ -*-
// Classes utilitaires pour representation de pixels et couleurs RGB pour PI
//                             R. Ansari  09/2008
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PIPIXUTILS_H_SEEN
#define PIPIXUTILS_H_SEEN

// =======  Classes utilitaires pour PIPixmap / PIImage =====
// 
// Definition d'un tableau pour gerer des index de couleurs en 8 bits / 16 bits
// 
class PIPixColIdx 
{
public:
  PIPixColIdx();
  ~PIPixColIdx();
  inline int XSize() { return sx_; }
  inline int YSize() { return sy_; }

  void AllocateByte(int sx, int sy);
  void AllocateShort(int sx, int sy);
  inline void DeAlloc() { AllocateByte(0,0); }

  inline unsigned char GetByte(int i, int j) const 
    { return pix8[j*sx_+i]; }
  inline unsigned char & GetByte(int i, int j)  
    { return pix8[j*sx_+i]; }

  inline unsigned short GetShort(int i, int j) const 
    { return pix16[j*sx_+i]; }
  inline unsigned short & GetShort(int i, int j)  
    { return pix16[j*sx_+i]; }
    
  inline unsigned char* BytePointer() { return pix8; }
  inline unsigned short* ShortPointer() { return pix16; }

protected:
  unsigned char * pix8;
  unsigned short * pix16;
  int sx_, sy_;
};


// 
// Definition de pixel et tableau de pixel RGB de 8 bits (byte)
// 

// Cette structure DOIT avoir la taille d'un entier de 4 bytes
struct PIPixRGB {
  unsigned char red;
  unsigned char green;
  unsigned char blue;
  unsigned char alpha;  // non utilise pour le moment 	
};
 
class PIPixRGBArray
{
public:	
  PIPixRGBArray(int sx, int sy);
  PIPixRGBArray(const char * filename);
  ~PIPixRGBArray();
  
  inline int XSize() { return sx_; }
  inline int YSize() { return sy_; }

  inline PIPixRGB operator()(int i, int j) const
    { return rgbpix_[j*sx_+i]; }
  inline PIPixRGB& operator()(int i, int j) 
    { return rgbpix_[j*sx_+i]; }
 
  int SaveToFile(const char * filename);
  int ReadFrFile(const char * filename);
    
protected:
  PIPixRGB * rgbpix_;  
  int sx_, sy_;  
};


#endif   /* PIPIXUTILS_H_SEEN */


