// Classes adaptateurs d'objets ImageMagick++ pour piapp 
//   R. Ansari -  Decembre 2008
//   (C)  Univ.Paris Sud LAL-IN2P3/CNRS    CEA-IRFU (DAPNIA)  

#ifndef IMAGMAGPI_H_SEEN
#define IMAGMAGPI_H_SEEN

#include "machdefs.h"
#include "sopnamsp.h"

#include <string>
#include <iostream>

#include "anydataobj.h"
#include "pipixutils.h"
#include "parradapter.h"
#include "nomgadapter.h"

#include <Magick++.h> 

// ---------------------------------------------------------------------------------
//  Classe heritant de AnyDataObj et de ImageMagick::Image pour utilisation ds piapp
// ---------------------------------------------------------------------------------

class ImgMagObj : public SOPHYA::AnyDataObj, public Magick::Image {
public:
// Read Image from file (jpeg, gif ...)
  ImgMagObj(string filename);
// Create a black image with the specified size
  ImgMagObj(const unsigned int width=10, const unsigned int height=10);
// Create an image from  a PIPixRGBArray  object 
  ImgMagObj(PIPixRGBArray const & rgba);
 
  virtual ~ImgMagObj() { } 
  
  inline unsigned int XSize() { return columns(); }
  inline unsigned int YSize() { return rows(); }
  
  inline PIPixRGB pixelPIRGB(const unsigned int ix, const unsigned int jy)
    { PIPixRGB rcol;     
      Magick::ColorRGB col = pixelColor(ix,jy); 
      rcol.red =  (unsigned char)(col.red()*255.);
      rcol.green =  (unsigned char)((float)col.green()*255.);
      rcol.blue =  (unsigned char)((float)col.blue()*255.);
      rcol.alpha = 0;
      return rcol;
    }
   
   void FillPIRGBArray(PIPixRGBArray& rgba);
    
// protected :  
};

// ------------------------------------------------------------------
//  Adapteur tableau 2D mode RGB pour affichage par PIImage 
class ImgMagP2DAdaptRGB : public P2DArrayAdapter {
public :
  ImgMagP2DAdaptRGB(Magick::Image * img, bool ad=false);
  virtual ~ImgMagP2DAdaptRGB();
  virtual double  Value(int ix, int iy); 
  virtual double  MeanVal(int ix1, int ix2, int jy1, int jy2);
protected :
  bool aDel;
  Magick::Image* mPix;
};

// ------------------------------------------------------------------
//  Adapteur tableau 2D mode GreyScale pour affichage par PIImage 
class ImgMagP2DAdaptGS : public P2DArrayAdapter {
public :
  ImgMagP2DAdaptGS(Magick::Image * img, bool ad=false);
  virtual ~ImgMagP2DAdaptGS();
  virtual double  Value(int ix, int iy); 
  virtual double  MeanVal(int ix1, int ix2, int jy1, int jy2);
protected :
  bool aDel;
  Magick::Image* mPix;
};

// ------------------------------------------------------------------
//  Adapteur d'objet ImgMagObj pour gestion  par NamedObjMgr de piapp
class NOMAdapter_ImgMag : public NObjMgrAdapter {
public:
                                NOMAdapter_ImgMag(ImgMagObj* img = NULL);
  virtual                       ~NOMAdapter_ImgMag();

  virtual NObjMgrAdapter*       Clone(AnyDataObj* o);
  virtual string                GetDataObjType();
  virtual P2DArrayAdapter*      Get2DArray(string& dopt);
  virtual NTupleInterface*      GetNTupleInterface(bool& adel);
  virtual void                  Print(ostream& os, int lev=0);

protected:
  ImgMagObj* mImg;

};

// ---- Class Interface NTuple pour ImgMagObj
class NTupInt_ImgMag : public NTupleInterface {
public:
                        NTupInt_ImgMag(ImgMagObj* img);
  virtual               ~NTupInt_ImgMag();
  virtual sa_size_t     NbLines() const ;
  virtual sa_size_t     NbColumns() const ;
  virtual r_8 *         GetLineD(sa_size_t n) const ;
  virtual string        VarList_C(const char* nomx=NULL) const ;
protected:
  ImgMagObj* mImg;
  mutable r_8 mRet[8];
};

// 
#endif
