#include "machdefs.h"
#include "sopnamsp.h"

#include <iostream>
#include <sstream>
#include <string>

#include "array.h"
#include "tarrinit.h"

#include "imgmag_pi.h"

 
using namespace std; 
using namespace Magick; 

int main(int argc,char **argv) 
{ 
  if (argc < 3) {
    cout << "  Usage: img2rgb  InputImageFile OutputFile \n" 
         << "    Input: jpeg/gif/...  OutFile: PI-RB (.rgb)  " << endl;
    return 0;
  }
/*
  cout << " Initializing image magick ... " << endl;
  InitializeMagick(argv[0]);
*/
  cout << " Initializing SOPHYA  ... " << endl;
  SophyaInit();

  try { 
    string infile = argv[1];
    cout << " Reading input file " << infile << endl;
    // Read a file into image object 
    ImgMagObj image(infile);
    cout << "Converting to PIPixRGBArray -  Width= " << image.columns()  
         << "  Height " << image.rows() << endl;
    PIPixRGBArray rgba(0,0);
    image.FillPIRGBArray(rgba);
    string outfile = argv[2];
    cout << " ---- writing rgbimg to file " << outfile << endl;
    rgba.SaveToFile(outfile.c_str());
  } 
  catch( Exception &error_ ) 
    { 
      cout << "Caught Exception: " << error_.what() << endl; 
      return 1; 
    } 
  catch( std::exception &error_ ) 
    { 
      cout << "Caught exception: " << error_.what() << endl; 
      return 1; 
    } 
  return 0; 
}
