#include "machdefs.h"
#include "sopnamsp.h"

#include <iostream>
#include <sstream>
#include <string>

#include "array.h"
#include "tarrinit.h"

#include "imgmag_pi.h"

 
using namespace std; 
using namespace Magick; 

int main(int argc,char **argv) 
{ 
  if (argc < 3) {
    cout << "  Usage: rgb2img  InputImageFile OutputFile \n" 
         << "     Input: PI-RB (.rgb)  Output: jpeg/gif/... " << endl;
    return 0;
  }
/*
  cout << " Initializing image magick ... " << endl;
  InitializeMagick(argv[0]);
*/
  cout << " Initializing SOPHYA  ... " << endl;
  SophyaInit();

  try { 
    string infile = argv[1];
    cout << " Reading input file " << infile << endl;
    // Read a file into an PIPixRGBArray
    PIPixRGBArray rgba(argv[1]);
    cout << "Converting to Magick::Image -  Width= " << rgba.XSize() 
         << " Height= " << rgba.YSize() << endl;
    ImgMagObj image(rgba);
    string outfile = argv[2];
    cout << " ---- writing Magick::Image to file " << outfile << endl;
    image.write(outfile);
  } 
  catch( Exception &error_ ) 
    { 
      cout << "Caught Exception: " << error_.what() << endl; 
      return 1; 
    } 
  catch( std::exception &error_ ) 
    { 
      cout << "Caught exception: " << error_.what() << endl; 
      return 1; 
    } 
  return 0; 
}
