#include "machdefs.h"
#include "sopnamsp.h"

#include <iostream>
#include <sstream>
#include <string>

#include "array.h"
#include "tarrinit.h"

#include "imgmag_pi.h"

 
using namespace std; 
using namespace Magick; 

// Conversion d'une serie de fichiers RGB en GIF anime

int main(int argc,char **argv) 
{ 
  if (argc < 4) {
    cout << "  Usage: animrgbs OutputFile InFile1 InFile2 InFile3 ...\n" 
         << "    Output: .gif  - InputFiles: PI-RB (.rgb) " << endl;
    return 0;
  }
/*
  cout << " Initializing image magick ... " << endl;
  InitializeMagick(argv[0]);
*/
  cout << " Initializing SOPHYA  ... " << endl;
  SophyaInit();

  try { 
    list<Image> imageList; 
    for(int k=2; k<argc; k++) {	
      // Read a file into an PIPixRGBArray
      cout << k-1 << "- Reading RGB file " << argv[k] << endl;
      PIPixRGBArray rgba(argv[k]);
      cout << "Converting to Magick::Image -  Width= " << rgba.XSize() 
         << " Height= " << rgba.YSize() << endl;
      ImgMagObj image(rgba);
      image.adjoin(true);
      image.animationDelay(10);  // en unite de 1/100 second -> 1/10 sec
      image.animationIterations(5);
      imageList.push_back(image);
      /*
      Image appended; 
      appendImages( &appended, imageList.begin(), imageList.end() ); 
      appended.write( "appended_image.miff" ); 
      */
    }
    string outfile = argv[1];
    cout << " ---- writing image sequence to file " << outfile << endl;
    writeImages(imageList.begin(), imageList.end(), outfile, true); 
  } 
  catch( Exception &error_ ) { 
    cout << "animrgbs: Caught Exception: " << error_.what() << endl; 
    return 1; 
  } 
  return 0; 
}
