/*    
   --- SOPHYA software - FitsIOServer module ---
   C. Magneville, 2006 
   (C) UPS+LAL IN2P3/CNRS     (C) DAPNIA-SPP/CEA 
*/
#ifndef FITSGENDATAHAND_H
#define FITSGENDATAHAND_H

#include "machdefs.h"
#include <string>

#include "generaldata.h"
#include "fitshandler.h"

namespace SOPHYA {

/*! 
  \ingroup FitsIOServer
  \brief FITS I/O handler for GeneralFitData objects
*/

inline FitsInOutFile& operator << (FitsInOutFile& os, GeneralFitData const & obj)
{ FitsHandler<GeneralFitData> fio(const_cast<GeneralFitData &>(obj));  fio.Write(os);  return os; }

inline FitsInOutFile& operator >> (FitsInOutFile& is, GeneralFitData & obj)
  { FitsHandler<GeneralFitData> fio(obj); is.SkipEmptyFirstHDU();
  fio.Read(is); is.MoveToNextHDU(); return(is); }


} // Fin du namespace

#endif
