/*    
   --- SOPHYA software - FitsIOServer module ---
   C. Magneville, 2007
   (C) UPS+LAL IN2P3/CNRS     (C) DAPNIA-SPP/CEA 
*/
#ifndef FITSHISTERRHAND_H
#define FITSHISTERRHAND_H

#include "machdefs.h"
#include <string>

#include "histerr.h"
#include "hist2err.h"
#include "fitshandler.h"

namespace SOPHYA {

/*! 
  \ingroup FitsIOServer
  \brief FITS I/O handler for HistErr objects
*/

inline FitsInOutFile& operator << (FitsInOutFile& os, HistoErr const & obj)
{ FitsHandler<HistoErr> fio(const_cast<HistoErr &>(obj));  fio.Write(os);  return os; }

inline FitsInOutFile& operator >> (FitsInOutFile& is, HistoErr & obj)
  { FitsHandler<HistoErr> fio(obj); is.SkipEmptyFirstHDU();
  fio.Read(is); is.MoveToNextHDU(); return(is); }

/*! 
  \ingroup FitsIOServer
  \brief FITS I/O handler for Histo2DErr objects
*/

inline FitsInOutFile& operator << (FitsInOutFile& os, Histo2DErr const & obj)
{ FitsHandler<Histo2DErr> fio(const_cast<Histo2DErr &>(obj));  fio.Write(os);  return os; }

inline FitsInOutFile& operator >> (FitsInOutFile& is, Histo2DErr & obj)
  { FitsHandler<Histo2DErr> fio(obj); is.SkipEmptyFirstHDU();
  fio.Read(is); is.MoveToNextHDU(); return(is); }


} // Fin du namespace

#endif
