#include "sopnamsp.h"
#include "fftwserver.h"

/*!
   \defgroup IFFTW IFFTW module
   Module containing interface classes between Sophya objects
   and FFTW Fourier transform package (see http://www.fftw.org )
*/

/*! 
  \class SOPHYA::FFTWServer
  \ingroup IFFTW
  An implementation of FFTServerInterface based on FFTW, double
  precision arrays, using FFTW package, availabale from http://www.fftw.org.
  Refer to FFTServerInterface for details about FFTServer operations.

  \code
  #include "fftwserver.h"
  // ...
  TMatrix<r_8> in(24,32);
  TMatrix< complex<r_8> > out;
  in = RandomSequence();
  FFTWServer ffts;
  ffts.setNormalize(true);  // To have normalized transforms
  cout << " FFTServer info string= " << ffts.getInfo() << endl;
  cout << "in= " << in << endl;
  cout << " Calling ffts.FFTForward(in, out) : " << endl;
  ffts.FFTForward(in, out);
  cout << "out= " << out << endl;
  \endcode

*/

#define MAXND_FFTW 5

#ifdef FFTW_V2_EXTSOP
#include "fftw2server.cc"
#else
#include "fftw3server.cc"
#endif

