#ifndef  FFTMAYER_H_SEEN
#define  FFTMAYER_H_SEEN
/*
** FFT and FHT routines
**  Copyright 1988, 1993; Ron Mayer
**  
**  fht(fz,n);
**      Does a hartley transform of "n" points in the array "fz".
**  fft(n,real,imag)
**      Does a fourier transform of "n" points of the "real" and
**      "imag" arrays.
**  ifft(n,real,imag)
**      Does an inverse fourier transform of "n" points of the "real"
**      and "imag" arrays.
**  realfft(n,real)
**      Does a real-valued fourier transform of "n" points of the
**      "real" arrays.  The real part of the transform ends
**      up in the first half of the array and the imaginary part of the
**      transform ends up in the second half of the array.
**  realifft(n,real)
**      The inverse of the realfft() routine above.
**      
**      
** NOTE: This routine uses at least 2 patented algorithms, and may be
**       under the restrictions of a bunch of different organizations.
**       Although I wrote it completely myself; it is kind of a derivative
**       of a routine I once authored and released under the GPL, so it
**       may fall under the free software foundation's restrictions;
**       it was worked on as a Stanford Univ project, so they claim
**       some rights to it; it was further optimized at work here, so
**       I think this company claims parts of it.  The patents are
**       held by R. Bracewell (the FHT algorithm) and O. Buneman (the
**       trig generator), both at Stanford Univ.
**       If it were up to me, I'd say go do whatever you want with it;
**       but it would be polite to give credit to the following people
**       if you use this anywhere:
**           Euler     - probable inventor of the fourier transform.
**           Gauss     - probable inventor of the FFT.
**           Hartley   - probable inventor of the hartley transform.
**           Buneman   - for a really cool trig generator
**           Mayer(me) - for authoring this particular version and
**                       including all the optimizations in one package.
**       Thanks,
**       Ron Mayer; mayer@acuson.com
**
*/

/*   Reza 4/02/99 : Introduced double AND float version   */
#include "machdefs.h"

#ifdef __cplusplus
extern "C" {
#endif

void fht_r4( r_4 *fz,int n);
void ifft_r4(int n, r_4 *real, r_4 *imag);
void realfft_r4(int n, r_4 *real);
void fft_r4(int n, r_4 *real,r_4 *imag);
void realifft_r4(int n,r_4 *real);

void fht_r8( r_8 *fz,int n);
void ifft_r8(int n, r_8 *real, r_8 *imag);
void realfft_r8(int n, r_8 *real);
void fft_r8(int n, r_8 *real,r_8 *imag);
void realifft_r8(int n,r_8 *real);

#ifdef __cplusplus
}
#endif

#endif
