#ifndef  FFTMServer_H_SEEN
#define  FFTMServer_H_SEEN

#include "fftservintf.h"

// implementation de FFTServerInterface en utilisant FFTPack 

namespace SOPHYA {

class FFTMayerServer : public FFTServerInterface {
 public:
  FFTMayerServer();
  virtual ~FFTMayerServer();

  // Implementation de l'interface FFTServerInterface

  virtual FFTServerInterface * Clone();

  // Transforme unidimensionnel sur des doubles
  virtual void FFTForward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< complex<r_8> > & out);
  virtual void FFTForward(TArray< r_8 > const & in, TArray< complex<r_8> > & out);
  virtual void FFTBackward(TArray< complex<r_8> > const & in, TArray< r_8 > & out,
			   bool usoutsz=false);


  // Transforme unidimensionnel sur des float
  virtual void FFTForward(TArray< complex<r_4> > const & in, TArray< complex<r_4> > & out);
  virtual void FFTBackward(TArray< complex<r_4> > const & in, TArray< complex<r_4> > & out);
  virtual void FFTForward(TArray< r_4 > const & in, TArray< complex<r_4> > & out);
  virtual void FFTBackward(TArray< complex<r_4> > const & in, TArray< r_4 > & out,
			   bool usoutsz=false);


protected:
  virtual bool checkLength(int n);

  FFTArrayChecker<r_4> ckR4;
  FFTArrayChecker<r_8> ckR8;
};

} // Fin du namespace




#endif
