#ifndef PIAPPLGEN_H_SEEN
#define PIAPPLGEN_H_SEEN

#include "pimsghandler.h"
#include "pisysdep.h"
#include PICONT_H
#include PIMENUBAR_H
// Fev 2008 : declaration enum PIConsole ds fichier piconsenum.h 
// et remplacement include picons.h par les deux lignes suivantes
#include "piconsenum.h"
class PIConsole;


class PIApplicationGen : public PIMsgHandler {
public:
        enum { kReadyState=0, kBusyState=1, kBlockedState=2 };

				  PIApplicationGen();
	virtual		          ~PIApplicationGen();
	
	virtual void              Run()=0;
	virtual void              Stop()=0;

        virtual void              SetReady();
        virtual void              SetBusy(); 
        virtual void              SetBlocked();
        virtual int               GetState();


	virtual PIContainer*      MainWin() {return topcont;}
        virtual PIMenubar*        Menubar() {return menubar;}

        virtual void              AppendMenu(PIMenu *pdm);

        virtual void              PrefCompSize(int& szx, int& szy) = 0;
        virtual void              ScreenSize(int& szx, int& szy) = 0;
        virtual void              ScreenSizeMM(int& szx, int& szy) = 0;
        virtual void              ScreenResolution(int& resolx, int& resoly) = 0;

        virtual void              RedirectOutStream(PIConsole* cons, unsigned char va= PIVA_Def)  = 0;
        virtual void              RedirectErrStream(PIConsole* cons, unsigned char va= PIVA_Red) = 0;

        virtual void              RedirectOutStream(PIConsole* cons, string const & flnm, bool fgcpos=false, 
						    unsigned char va= PIVA_Def)  = 0;
        virtual void              RedirectErrStream(PIConsole* cons, string const & flnm, bool fgcpos=false, 
						    unsigned char va= PIVA_Def)  = 0;

protected:
    PIContainer               *topcont;
    PIMenubar                 *menubar;
    int                       mState;
};

//   Fonction globale pour recuperer la taille standard des composants (taille x,y) 
void     PIApplicationPrefCompSize(int& szx, int& szy);  
void     PIApplicationScreenSize(int& szx, int& szy);  
void     PIApplicationScreenSizeMM(int& szx, int& szy);  
void     PIApplicationScreenResolution(int& resolx, int& resoly);

#endif
