// This may look like C code, but it is really -*- C++ -*-
// Module PI : Peida Interactive     PIThermometer
// Thermometre                   R. Ansari  05/00
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#ifndef PITHERM_H_SEEN
#define PITHERM_H_SEEN

#include "pisysdep.h"

#include PIBWDG_H

class PIThermometer : public PIBaseWdg
{
public:
  enum {ClassId = 5220};

                  PIThermometer(PIContainerGen *par, char *nom,
                                int sx=256, int sy=10, int px=0, int py=0);
  virtual         ~PIThermometer();

  virtual long	  kind() {return ClassId; }
  virtual void    SetMinMax(double min=0., double max=1.);
  virtual void    GetMinMax(double& min, double& max);
  virtual void    SetValue(double val);
  virtual double  GetValue(); 
  virtual void    SetThreshold(double t1=0.75, double t2=0.9);
  virtual void    GetThreshold(double& t1, double& t2);
  virtual void    SetColors(PIColors c1=PI_Green, PIColors c2=PI_Yellow, 
                            PIColors c3=PI_Red);

// Traitement des evenements   

  virtual void   Draw(PIGraphic* g, int x0, int y0, int dx, int dy);


protected:
  double min_, max_, val_;
  double thr1_, thr2_;
  PIColors lowc_, medc_, highc_;
  double lastperc_;
};


#endif 
