//  Adaptateurs et Drawers divers pour Outils PEIDA++
//                             R. Ansari  06-08/98
// LAL (Orsay) / IN2P3-CNRS  DAPNIA/SPP (Saclay) / CEA

#include "sopnamsp.h"
#include "pipodrw.h"
#include "generalfit.h"


//================================================================
// PIGFFDrawer
//================================================================

PIGFFDrawer::PIGFFDrawer(GeneralFunction* f)
: mFunc(f), mNParms(f->NPar()), mParms(new double[mNParms])
{
  ASSERT(f->NVar() == 1);
}

PIGFFDrawer::~PIGFFDrawer()
{
  delete[] mParms;
}

void
PIGFFDrawer::SetParms(double const* p)
{
  for (int i=0; i<mNParms; i++)
    mParms[i] = p[i];
}


void
PIGFFDrawer::Draw(PIGraphicUC* g, double /*xmin*/, double/*ymin*/, double/*xmax*/, double/*ymax*/)
{
  PIGrCoord x1, x2, y1, y2;
  g->GetGrSpace(x1, x2, y1, y2);
  double xMax = x2;
  double xMin = x1;
  double yMax = y2;
  double yMin = y1;
  double xStep = (xMax - xMin)/100;
  double xOld = xMin;
  double yOld = 0;
//  double yOld = f->Value(&xMin, mParms);
  for (double x = xMin+xStep; x<xMax; x+=xStep) {
   double y = 0; // $CHECK$
//    double y = f->Value(&x, mParms);
    if (y>yMin && yOld>yMin && 
        y<yMax && yOld<yMax) 
           g->DrawLine(xOld, yOld, x, y);
    xOld = x;
    yOld = y;
  }
}



