#ifndef PIMGADAPTER_SEEN
#define PIMGADAPTER_SEEN

#include "cimage.h"
#include "parradapter.h"


template <class T> 
class ImageAdapter : public P2DArrayAdapter {
public:
                  ImageAdapter(Image<T>* img, bool ad=false) :
                    P2DArrayAdapter(img->XSize(), img->YSize())
                    { aDel = ad; mImg = img; 
                    DefineXYCoordinates(img->XOrg(), img->YOrg(), 1., 1. ); }

  virtual 	  ~ImageAdapter() { if (aDel) delete mImg; }
  virtual double  Value(int ix, int iy) { return((*mImg)(ix, iy)); }
  virtual double  MeanVal(int ix1, int ix2, int jy1, int jy2)  
    {
    int ec;
    if (ix1>ix2) { ec=ix1; ix1=ix2; ix2=ec; }
    if (jy1>jy2) { ec=jy1; jy1=jy2; jy2=ec; }    
    double ss = 0.;
    for(int j=jy1; j<=jy2; j++) 
      for(int i=ix1; i<=ix2; i++)  ss += (double)((*mImg)(i, j));
    ss /= (double)((jy2-jy1+1)*(ix2-ix1+1));
    return ss;  
    }   

protected :
  bool aDel;
  Image<T>* mImg;
};

#endif
