#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include "sopnamsp.h"

#include "fitsfile.h"
#include "fitsmanager.h"
#include "fiosinit.h"
/*
#include "histinit.h"
#include "dvlist.h"
#include "ntuple.h"
#include "fitsntuple.h"
*/
/*!
  \ingroup PrgUtil
  \file scanfits.cc
  \brief \b scanfits: Check and scan FITS files 

  Scan FITS files and prints information on each FITS bloc in file.
  Uses the FitsIOServer module. 

  \verbatim
  csh> scanfits -h
  PIOPersist::Initialize() Starting Sophya Persistence management service 
  SOPHYA Version  1.9 Revision 25 (V_Dec2005) -- Jan  4 2006 14:50:01 cxx 
  Usage: scanfits [flags] filename 
  flags = -V1 -lh -rd -header 
    -V1 : Scan using old (V1) code version 
    -lh : Print the list of registered handlers (FitsHandlerInterface) 
    -rd : try to read each HDU data using appropriate handler 
    -header : List header information 
  \endverbatim
 */

string FITSExtType2String(FitsFile::FitsExtensionType exttype)
{
  if (exttype == FitsFile::FitsExtensionType_IMAGE) return("IMAGE");
  else if (exttype == FitsFile::FitsExtensionType_ASCII_TBL) return("ASCII_TBL");
  else if (exttype == FitsFile::FitsExtensionType_BINARY_TBL) return("BINARY_TBL");
  else if (exttype == FitsFile::FitsExtensionType_EOF) return("EOF");
  else if (exttype == FitsFile::FitsExtensionType_ERROR) return("ERROR");
  else return("Unknown?");
}

string FITSDataType2String(FitsFile::FitsDataType datatype)
{
  if (datatype == FitsFile::FitsDataType_double) return("double");
  else if (datatype == FitsFile::FitsDataType_float) return("float");
  else if (datatype == FitsFile::FitsDataType_int) return("int");
  else if (datatype == FitsFile::FitsDataType_long) return("long");
  else if (datatype == FitsFile::FitsDataType_byte) return("byte");
  else if (datatype == FitsFile::FitsDataType_char) return("char");
  else if (datatype == FitsFile::FitsDataType_ASCII) return("ASCII");
  else if (datatype == FitsFile::FitsDataType_NULL) return("NULL");
  else return("Unknown?");
}

static int scanV1(string & flnm) 
{
  char * argnm = new char[ flnm.length()+1 ];
  strcpy(argnm, flnm.c_str());
  int nbblk = FitsInFile::NbBlocks(argnm);
  cout << " :::::::: File " << flnm << " has " << nbblk << " blocks " 
       << " :::::::: " << endl;
  
  
  for(int i=1; i<=nbblk; i++) {
    int naxis;
    vector<int> axis;
    DVList header;
    FitsFile::FitsExtensionType exttype;
    FitsFile::FitsDataType datatype;
    
    FitsInFile::GetBlockType(argnm, i, exttype, naxis, axis, datatype, header);
    cout << "\n--------- Header Num " << i << " Type " << FITSExtType2String(exttype) 
	 << "  --- NAxis= " << naxis 
	 << " DataType= " << FITSDataType2String(datatype) << endl;
    if (axis.size() > 0) { 
      cout << " >> Axis Sizes: " ;
      for(int j=0; j<axis.size(); j++) { 
	if (j > 0) cout << " x " ;
	cout  << axis[j] ;
      }
      cout << endl;
    }
    cout << " >>> Header info : " ;
    cout << header << endl;
    cout << "----------------------------------------------------------------------" 
	 << endl;
  } 
  delete[] argnm;
  return 0;
}

int main(int narg, char *arg[]) 
{
  if ((narg < 2) || (strcmp(arg[1],"-h") == 0) ) {
    cout << " Usage: scanfits [flags] filename \n" 
	 << " flags = -V1 -lh -rd -header \n"
	 << "   -V1 : Scan using old (V1) code version \n"  
	 << "   -lh : Print the list of registered handlers (FitsHandlerInterface) \n" 
	 << "   -rd : try to read each HDU data using appropriate handler \n" 
	 << "   -header : List header information \n" << endl;
    return(0);
  }
  bool fgv1 = false;
  bool fgrd = false;
  bool fglh = false;
  bool fghd = false;
  bool fgflnm = false;
  string flnm = "";
  for (int k=1; k<narg; k++)   {
    if (strcmp(arg[k], "-V1") == 0)  fgv1 = true;
    else if (strcmp(arg[k], "-rd") == 0)  fgrd = true;
    else if (strcmp(arg[k], "-lh") == 0)  fglh = true;
    else if (strcmp(arg[k], "-header") == 0)  fghd = true;
    else { 
      fgflnm = true; flnm = arg[k]; 
      break; 
    }
  }
  int slev = 0;
  if ( fgrd ) slev = 2;
  if ( fghd ) slev += 1;
  if (!fglh && !fgflnm) {
    cout << " scanfits/Erreur : no file name specified and no -lh " << endl;
    return 1;
  }
  try {
    SophyaInit();
    FitsIOServerInit();
    cout << " ====== scanfits: FileName= " << flnm << " ==== " << endl;
    if ( fglh ) FitsManager::ListHandlers();
    if ( fgflnm ) {
      if ( fgv1 ) scanV1(flnm);
      else FitsManager::ScanFile(flnm, slev);
    }
  }
  catch (PThrowable & exc) {
    cerr << "sanfits: Catched Exception " << (string)typeid(exc).name()
         << "\n .... Msg= " << exc.Msg() << endl;
  }
  catch (...) {
    cerr << " some other exception was caught ! " << endl;
  }

}
