// toisvr.h
// Eric Aubourg         CEA/DAPNIA/SPP   juillet 1999


#ifndef TOISVR_H
#define TOISVR_H

#include "toiiter.h"

class AuxGPS;

class TOISvr {
public:
  TOISvr();
  
  void SetDirectory(string);
  void AddFile(string);
  void OnBoardRecorderFiles(bool);
  void SetMJD0(double);
  void SetPerEch(double);
  void UseAuxGPS(AuxGPS* gps);
  
  void SetTimeInterval(double tStart, double tEnd);
  
  void AddInfo(TOIKind kind, int index, bool triggering=true, bool interp=false);
  void AddInfo(TOIKind kind, bool triggering=true, bool interp=false);
  
  TOIIter DoQuery();
  
  
protected:
  TOIIter iter;
};


#endif
