#include "asigps.h"
#include <fstream.h>

ASIGPS::ASIGPS(string const& filename) {
  readFile(filename);
}

void ASIGPS::readFile(string const& filename) {
  ifstream f(filename.c_str());
  while (f) {
    char line[200];
    f.getline(line,200);
    if (!f) break;
    char*p = line;
    double mjd, lat, lon, alt;
    if (*p != '3' && *p != '2') continue;
    p++;
    if (*p != 'D' && *p != 'd') continue;
    p+=3;
    if (strncmp(p,"99/jul/1",8)) continue;
    p+=8;
    if (*p == '7') mjd = 1376.5;
    else if (*p == '8') mjd = 1377.5;
    else continue;
    p++;p++;
    int h,m,s;
    sscanf(p,"%2d:%2d:%2d",&h,&m,&s);
    mjd += (h+m/60.+s/3600.)/24.;
    p += 9;
    if (*p == 'N') s = 1;
    else if (*p == 'S') s = -1;
    else continue;
    p++;
    int d,fm;
    sscanf(p,"%2d.%2d,%3d",&d,&m,&fm);
    lat = s*(d + m/60. + fm/60000.);
    p+=10;
    if (*p == 'E') s = 1;
    else if (*p == 'W') s = -1;
    else continue;
    p++;
    sscanf(p,"%3d.%2d,%3d",&d,&m,&fm);
    lon = s*(d + m/60. + fm/60000.);
    p+=11;
    sscanf(p,"%5d",&d);
    alt = d;
    p+=5;
    if (*p != 'm') continue;
    AddValue(mjd, lat, lon, alt);
  }
}