#ifndef  MINIFITS_H_SEEN
#define  MINIFITS_H_SEEN

#include <stdio.h>
#include <string>

#include "brtypes.h"

/* 
   Classe d'I/O simplifie FITS pour ACQ BAO-radio  
   R. Ansari, C. Magneville -      Fev 2008
*/

using namespace std;

class MiniFITSException {
  public:
  explicit MiniFITSException(const char * m) { msg = m; }
  explicit MiniFITSException(const string& m) { msg = m; }
  virtual ~MiniFITSException() { } 
  virtual string const& Msg() const  {return msg;}
 private:
  string msg;
};


enum MiniFITS_DT { MF_Byte, MF_Int16, MF_Float32 };
enum MiniFITS_Mode { MF_Read, MF_Write };

class MiniFITSFile {
 public:
  MiniFITSFile();
  MiniFITSFile(string const & nom, MiniFITS_Mode rwm);
  MiniFITSFile(const char* nom, MiniFITS_Mode rwm);

  ~MiniFITSFile();

  void Open(const char* nom, MiniFITS_Mode rwm);
  inline void Open(string const & nom, MiniFITS_Mode rwm)
    { return Open(nom.c_str(), rwm); }

  void Close();

  inline MiniFITS_DT DataType() { return dtype; }
  string DataTypeToString();  

  size_t NAxis1() { return nax1; }
  size_t NAxis2() { return nax2; }

  void setDTypeNaxis(MiniFITS_DT dt, size_t na1, size_t na2);

  // Lecture avec indication de la taille (nb d'elements) et offset 
  int Read(void* data, size_t sz, size_t offset=0);
  inline int ReadB(Byte* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel, offsel) ); }
  inline int ReadI(Int16* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel*sizeof(Int16), offsel*sizeof(Int16)) ); }
  inline int ReadF(Float32* data, size_t nel, size_t offsel=0)
    { return ( Read((void *)data, nel*sizeof(Float32), offsel*sizeof(Float32)) ); }

  // Ecriture en mode append (fin de fichier) 
  int Write(void* data, size_t sz);
  inline int WriteB(Byte* data, size_t nel) 
    { return ( Write((void *)data, nel) ); }
  inline int WriteI(Int16* data, size_t nel) 
    { return ( Write((void *)data, nel*sizeof(Int16)) ); }
  inline int WriteF(Float32* data, size_t nel) 
    { return ( Write((void *)data, nel*sizeof(Float32)) ); }

  //  string getKey(string& key);
 protected:
  void FillHeader();
  void DecodeHeader();
  void Init();
  
  FILE* fip;
  MiniFITS_Mode rwmode;
  MiniFITS_DT dtype;
  size_t nax1, nax2;
  size_t totwsz;  // total bytes ecrits
  char* header; //  entete FITS
};

#endif
