#include "sopnamsp.h"
#include "machdefs.h"
#include <iostream>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include "timing.h"
#include "ntuple.h"

#include "cosmocalc.h"
#include "pkspectrum.h"

void usage(void);
void usage(void) {cout<<"cmvtgrowth z1,z2,dz [Omatter0,Lambda0]"<<endl;}

void tstprint(CosmoCalc& univ,double z1,double z2,double dz);
void tstspeed(CosmoCalc& univ,double z1,double z2,double dz);
void tstntuple(CosmoCalc& univ,double z1,double z2,double dz);

int main(int narg,char *arg[])
{

 double z1=0., z2=10., dz=1.;
 if(narg>1) sscanf(arg[1],"%lf,%lf,%lf",&z1,&z2,&dz);
 cout<<"z1="<<z1<<"  z2="<<z2<<"  dz="<<dz<<endl;

 double om0=0.267804, ol0=0.73;
 if(narg>2) sscanf(arg[2],"%lf,%lf",&om0,&ol0);
 cout<<"Om0="<<om0<<"  Ol0="<<ol0<<endl;

 GrowthFactor growth(om0,ol0);
 cout<<"D1(z=0) = "<<growth(0.)<<endl;

 const int n = 2;
 const char *vname[n] = {"z","d1"};
 NTuple nt(n,vname);
 double xnt[n];
 for(double z=z1;z<z2+dz/2.;z+=dz) {
   xnt[0]  = z;
   xnt[1]  = growth(z);
   nt.Fill(xnt);
 }

 cout<<">>>> Ecriture"<<endl;
 string tag = "cmvtgrowth.ppf";
 POutPersist pos(tag);
 tag = "nt"; pos.PutObject(nt,tag);

 return 0;
}


/*
openppf cmvtgrowth.ppf

set cut 1
set cut z<5

n/plot nt.d1%z $cut ! "nsta connectpoints"
n/plot nt.1./(1.+z)%z $cut ! "nsta connectpoints red same"
*/
