// This may look like C code, but it is really -*- C++ -*-
// Tirages aleatoires sur une fonction (thread safe)
// C. Magneville   2009
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef TSFUNRAN_SEEN
#define TSFUNRAN_SEEN

#include "machdefs.h"
#include <stdlib.h>
#include <math.h>
#include "histos.h"
#include "tvector.h"
#include "stsrand.h"
#include "classfunc.h"

namespace SOPHYA {  

class TsFunRan : public Histo {
public:
  typedef r_8 (*Func)(r_8);
  TsFunRan(ClassFunc& f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBin=100, bool pdf=true);
  TsFunRan(Func f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBin=100, bool pdf=true);
  TsFunRan(r_8 *tab, int_4 nBin, bool pdf=true);
  TsFunRan(r_8 *tab, int_4 nBin, r_8 xMin, r_8 xMax, bool pdf=true);
  TsFunRan(TVector<r_8>& tab, int_4 nBin, bool pdf=true);
  TsFunRan(TVector<r_8>& tab, int_4 nBin, r_8 xMin, r_8 xMax, bool pdf=true);
  TsFunRan(Histo &h, bool pdf=true);
  TsFunRan(const TsFunRan& fh);
  TsFunRan(void);
  virtual ~TsFunRan(void);

  void SetRandomGenerator(RandomGenerator& rg);

  int_4 BinRandom(void);
  r_8 Random(void);
  r_8 RandomInterp(void);
protected:
  void create_DF(bool pdf);
  RandomGenerator* rg_;
};

} // namespace SOPHYA

#endif
