// This may look like C code, but it is really -*- C++ -*-
// Classe d ajustement pour  piapp 
// cmv                            98-99
// CEA-DAPNIA      LAL-IN2P3/CNRS

#ifndef PIAFITTING_H_SEEN
#define PIAFITTING_H_SEEN

#include "machdefs.h"
#include <string>
#include <vector>
#if defined(__KCC__)
using std::string ;
#include <vector.h>
#endif

#include "anydataobj.h"

#include "pdlmgr.h"
#include "dlftypes.h"
#include "piacmd.h"

class Vector;
class PIStdImgApp;

class PIAFitter : public CmdExecutor {
public :
                        PIAFitter(PIACmd* piac, PIStdImgApp* app);
  virtual               ~PIAFitter();
  virtual int	        Execute(string& keyw, vector<string>& args);

//   Methodes de fit -  CMV , deux methodes H1 H2 ou 1 seule ??) ...
  virtual void          Fit12D(string & nom, string& func,
                               string par,string step,string min,string max,string opt);

protected :
typedef struct DFOptions {
  int okres, okfun;
  int polcx,polcy; double xc,yc;
  double err_e, err_E;
  double stc2;
  int nstep;
  int lp,lpg;
  int i1,i2,j1,j2;
} DFOPTIONS ;

  static void DecodeFitsOptions(string par,string step,string min,string max,string opt
                               ,Vector& Par,Vector& Step,Vector& Min,Vector& Max,DFOPTIONS& O);
};

#endif
