// This may look like C code, but it is really -*- C++ -*-
// Nombres aleatoires pour Peida.
// C. Magneville   1996-2000
// DAPNIA/SPP (Saclay) / CEA    LAL - IN2P3/CNRS  (Orsay)

#ifndef PERANDOM_SEEN
#define PERANDOM_SEEN

#include "machdefs.h"
#include <stdlib.h>
#include <math.h>
#include "tvector.h"
#include "histos.h"
#include "classfunc.h"

namespace SOPHYA {  

class FunRan : public Histo {
public:
  typedef r_8 (*Func)(r_8);
  FunRan(ClassFunc& f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBin=100, bool pdf=true);
  FunRan(Func f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBin=100, bool pdf=true);
  FunRan(r_8 *tab, int_4 nBin, bool pdf=true);
  FunRan(r_8 *tab, int_4 nBin, r_8 xMin, r_8 xMax, bool pdf=true);
  FunRan(TVector<r_8>& tab, bool pdf=true);
  FunRan(TVector<r_8>& tab, r_8 xMin, r_8 xMax, bool pdf=true);
  FunRan(Histo &h, bool pdf=true);
  FunRan(const FunRan& fh);
  FunRan(void);

  int_4 BinRandom(void);
  r_8 Random(void);
  r_8 RandomInterp(void);
protected:
  void create_DF(bool pdf);
};

class FunRan2D  {
public:
//  typedef r_8 (*Func)(r_8, r_8);
//  FunRan2D(Func f, r_8 xMin=0.0, r_8 xMax=1.0, int_4 nBinX=100,
//                   r_8 yMin=0.0, r_8 yMax=1.0, int_4 nBinY=100);
  FunRan2D(r_8 *tab, int_4 nBinX, int_4 nBinY);
  FunRan2D(r_8 **tab, int_4 nBinX, int_4 nBinY);
  ~FunRan2D();
  void Random(r_8& x, r_8& y);
  void BinRandom(int_4& x, int_4& y);
private:
  FunRan* ranX;
  FunRan** ranY;
  int_4 nx;
};

} // namespace SOPHYA

#endif
