#!/bin/csh
# Pour changer "smakefile" en "Makefile"
# - Pas d'argument: tous les repertoire CVS sous la racine
# - $1 : nom du perpertoire a traiter
# ATTENTION: a lancer depuis la racine Sophya:
# > ./BuildMgr/change_smake2make.csh
# > ./BuildMgr/change_smake2make.csh XephemAstroLib
set CURDIR = `pwd`

#--- Recherche des repertoires sous CVS
if( $#argv > 0 ) then
  set dcvs = ( $* )
else
  set dcvs =
  foreach f ( `ls -1` )
    if( -e $f/CVS ) set dcvs = ( $dcvs $f )
  end
endif

#--- Action CVS dans chacun des repertoires concernes
foreach d ( $dcvs )
  if (-e $CURDIR/$d)  then
    cd $CURDIR/$d
    if( ! -e Makefile ) continue
    if( ! -e smakefile ) continue
    grep -q 'include ../BuildMgr/sophyamake.inc' Makefile
    if( $status != 0 ) continue
    grep -q 'include $(SOPHYABASE)/include/sophyamake.inc' smakefile
    if( $status != 0 ) continue
    sed 's?include $(SOPHYABASE)/include/sophyamake.inc?include ../BuildMgr/sophyamake.inc?' smakefile >! Makefile
    echo ">>> $d : Makefile generated from smakefile"
    diff smakefile Makefile
  endif
end


exit 0

