#include "sopnamsp.h"
#include "machdefs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "math.h"
#include <iostream>
#include <string>

#include <typeinfo>
#include "timing.h"
#include "histinit.h"
#include "pexceptions.h"
#include "ppfwrapstlv.h" 

/*  Programme test du PPFWrapper pour les vecteurs de la STL */
/*  SOPHYA - R. Ansari (LAL)  -   Avril 2005                 */
 
int main(int narg, char* arg[])
{
  if ((narg > 1) && (strcmp(arg[1],"-h") == 0) ) {
    cout << " tstppfwrapstl : Test classes PPFWrapper \n"
	 << "   Usage: tstppfwrapstl [VectorSize=10] [prtlev=0,1] " << endl;
    return 0;
  }
  cout << " ---- Programme tstppfwrapstl.cc ---- \n" 
       << "      ::: Test classes PPFWrapper de std::vector ::: " << endl;
  int prtlev = 0;
  int SZV = 10;
  if (narg > 1) SZV = atoi(arg[1]); 
  if (narg > 2) prtlev = atoi(arg[2]);
  cout << " ----- Test PPFWrapperSTLVector<T> Size= " << SZV << " PrtLev= " 
       << prtlev << endl;
  int rc = 0;
  try {
    SophyaInit();

    InitTim(); 
    vector<float> vw(SZV);
    for(int k=0; k<SZV; k++) vw[k] = 3.141596*k;
    #define MyNSC 6 
    const char * strcst[MyNSC] = { "Langage C++" , "Programmation Objet", "Calcul scientifique",
			   "Librairie de classes", "SOPHYA", " et Java alors ?"};

    cout << "1/ Initialisation  vector<float> vf , vector<int> vi , vector<string> vs " << endl;
    
    vector<float> vf(SZV);
    vector<string> vs(SZV); 
    vector<int> vi(SZV);
    for(int k=0; k<SZV; k++) { 
      vf[k] = 3.141596*k;
      vs[k] = strcst[k%MyNSC];
      vi[k] = random();
    }
    if (prtlev > 0) {
      cout << "  vector<float> vf Size= " << vf.size() << " values: \n" ;
      int k;
      for(k=0; k<vf.size(); k++) cout << vf[k] << " ;  ";
      cout << endl;
      cout << "  vector<int> vi Size= " << vi.size() << " values: \n" ;
      for(k=0; k<vi.size(); k++) cout << vi[k] << " ;  ";
      cout << endl;
      cout << "  vector<string> vs Size= " << vs.size() << " values: \n" ;
      for(k=0; k<vs.size(); k++) cout << vs[k] << " ;  ";
      cout << endl;
    }
    {
      cout << "2/  Ecriture vf vi vs ds  fichier wrapstl.ppf" << endl;
      POutPersist so("wrapstl.ppf");
      so << PPFNameTag("STLVec<float>") << vf; 
      so << PPFNameTag("STLVec<string>") << vs; 
      so << PPFNameTag("STLVec<int>") << vi; 
    }
    vector<string> vsr;
    vector<int> vir;
    vector<float> vfr;
    {
      cout << "3/ Relecture vfr vir vsr depuis fichier wrapstl.ppf " << endl;
      PInPersist si("wrapstl.ppf");
      si >> PPFNameTag("STLVec<string>") >> vsr >> vir; 
      si >> PPFNameTag("STLVec<float>") >> vfr;
      if (prtlev > 0) {
	cout << "  vector<float> vfr Size= " << vfr.size() << " values: \n" ;
	int k;
	for(k=0; k<vfr.size(); k++) cout << vfr[k] << " ;  ";
	cout << endl;
	cout << "  vector<int> vir Size= " << vir.size() << " values: \n" ;
	for(k=0; k<vir.size(); k++) cout << vir[k] << " ;  ";
	cout << endl;
	cout << "  vector<string> vsr Size= " << vsr.size() << " values: \n" ;
	for(k=0; k<vsr.size(); k++) cout << vsr[k] << " ;  ";
	cout << endl;
      }
    }
    cout << "3/ Comparaison vfr<>vf vir<>vr vsr<>vr  " << endl;
    int k;
    if (vfr.size() != vf.size()) {
      cout << "  ... Difference de taille vf et vfr " << endl;
      rc += 1;
    }
    else {
      int ndiff = 0;
      for(k=0; k<vfr.size(); k++) 
	if (vfr[k] != vf[k]) ndiff ++;
      if (ndiff != 0) { 
	cout << " vf <> vfr  NDiff = " << ndiff << endl;
	rc += 2;
      }
    }
    if (vir.size() != vi.size()) {
      cout << "  ... Difference de taille vi et vir " << endl;
      rc += 4;
    }
    else {
      int ndiff = 0;
      for(k=0; k<vir.size(); k++) 
	if (vir[k] != vi[k]) ndiff ++;
      if (ndiff != 0) { 
	cout << " vi <> vir  NDiff = " << ndiff << endl;
	rc += 8;
      }
    }
    if (vsr.size() != vs.size()) {
      cout << "  ... Difference de taille vi et vir " << endl;
      rc += 16;
    }
    else {
      int ndiff = 0;
      for(k=0; k<vsr.size(); k++) 
	if (vsr[k] != vs[k]) ndiff ++;
      if (ndiff != 0) { 
	cout << " vs <> vsr  NDiff = " << ndiff << endl;
	rc += 32;
      }
    }
    if (rc == 0) cout << " .... Comparaison OK " << endl;

  }
  catch (PThrowable & exc) {
    cerr << " tstppfwrapstl.cc: Catched Exception (PThrowable)" << (string)typeid(exc).name() 
	 << " - Msg= " << exc.Msg() << endl;
    rc = 99;
  }
  catch (std::exception & e) {
    cerr << " tstppfwrapstl.cc: Catched std::xception "  
	 << " - what()= " << e.what() << endl;
    rc = 98;
  }
  catch (...) {
    cerr << " tstppfwrapstl.cc: some other exception (...) was caught ! " << endl;
    rc = 97;
  }
  PrtTim("End tstppfwrapstl  " );
  cout << " ---- Programme tstppfwrapstl.cc -  FIN  (Rc=" << rc << ") --- " << endl;
  return rc;
}
