#include "pciewrap.h"
#include "brpaqu.h"

#include "racqumem.h"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>

TestPCIWrapperNODMA::TestPCIWrapperNODMA(UInt32 sz) 
  : PCIEWrapper() , size_(sz)
{
  data_ = new Byte[size_];
  frame_counter_ = 0;
  timetag_ = 0;
  tottransfer_ = 0;	
}

TestPCIWrapperNODMA::~TestPCIWrapperNODMA()
{
  delete[] data_;	
}

UInt32 TestPCIWrapperNODMA::TransferSize()
{
  return size_;	
}

UInt64 TestPCIWrapperNODMA::TotTransferBytes()
{
  return tottransfer_;
}

Byte* TestPCIWrapperNODMA::DoTransferData(int numbuff)
{
  frame_counter_ ++;
  timetag_ = frame_counter_ * size_ / 2;
  BRPaquet paq(data_, size_);
  paq.SetHDRMarker64(pchk_.HDRTag());
  paq.SetTRLMarker64(pchk_.TRLTag());
  paq.SetFrameCounter(frame_counter_);
  paq.SetTimeTag(timetag_);
  paq.SetPaqLen((UInt16)((size_ - BRHDRSIZE - BRTRLSIZE)/4));
  Byte* bp = paq.Data1();
  for(UInt32 kk=0; kk<paq.DataSize(); kk++) 
    bp[kk] = (Byte)(sin(0.0345*kk)*78.+127.5);
  tottransfer_ += size_;
  return data_;
}

void TestPCIWrapperNODMA::PrintStatus(ostream& os) 
{
  os << "TestPCIWrapperNODMA::Status, FrameCounter=" << frame_counter_ 
     << " TimeTag=" << timetag_ << endl;
}