#ifndef  PCIEWRAP_H_SEEN
#define  PCIEWRAP_H_SEEN
#include "brtypes.h"
#include "machdefs.h"
#include "racqumem.h"
#include "brpaqu.h"
#include <string>

/* 
   Classe interface aux fonctions d'I/O PCIExpress 
   pour la carte de reception optique BAORadio
   R. Ansari                        Juin 2008
*/

using namespace std;

class PCIEWException {
  public:
  explicit PCIEWException(const char * m) { msg = m; }
  explicit PCIEWException(const string& m) { msg = m; }
  virtual ~PCIEWException() { }
  virtual string const& Msg() const  {return msg;}
  virtual const char* what() {return msg.c_str(); }
 private:
  string msg;
};


// Classe definissant l'interface des operations transfert DMA/PCIExpress 
class PCIEWrapper {
 public:
  // Constructeur - fait l'initialisation
  PCIEWrapper() { } 
  // destructeur - libere la memoire allouee
  virtual ~PCIEWrapper() { } 

  virtual UInt32 TransferSize() = 0;
  virtual Byte* DoTransferData(int numbuff=0) = 0;
  virtual UInt64 TotTransferBytes() = 0;    
  virtual void PrintStatus(ostream& os) = 0;
};

// Classe de test Implementant l'interface PCIEWrapper sans DMA 
class TestPCIWrapperNODMA : public PCIEWrapper {
public:	
  TestPCIWrapperNODMA(UInt32 sz);
  virtual ~TestPCIWrapperNODMA();

  virtual UInt32 TransferSize() ;
  virtual Byte* DoTransferData(int numbuff=0) ;
  virtual UInt64 TotTransferBytes() ;    
  virtual void PrintStatus(ostream& os) ;
  
protected:
  Byte* data_;
  UInt32 size_;
  UInt32 frame_counter_;
  UInt64 timetag_; 	
  UInt64 tottransfer_;
  BRPaqChecker pchk_;
};

#endif
