#ifndef  RACQUMEM_H_SEEN
#define  RACQUMEM_H_SEEN

//----------------------------------------------------------------
// ---- classes de gestion memoire pour acquisition BAORadio -----
// LAL -      R. Ansari - Juin/Juillet 2008 
//       Modifs Mai 2009 
//       - Introduction du numero d'ordre de remplissage 
//       - Introduction de mask de recyclage et sequence de traitement procA/B/C
//----------------------------------------------------------------


#include "machdefs.h"
#include <string>
#include <vector>
#include <iostream>
#include "sopnamsp.h"
#include "zthread.h"
// #include "dmamgrintf.h"
#include "brtypes.h"
#include "pciewrap.h"
using namespace std;

// Structure de gestion utilisee par la classe RAcqMemMgr
typedef struct {
  uint_8 serial;    // Numero de serie permettant d'ordonner en temps les zones memoire rempli
  uint_4 act;       // Indique l'action en cours sur une zone Fill,Save ...
  uint_4 stat;      // Champ de flag (bits) indiquant les operations effectuees sur la zone
  uint_4 nbact[6];  // compteurs nb de fois ou (fill,save,proc,procA/B/C) a ete effectuee sur la zone 
//  int tid;        Pas utilise pour le moment, permet l'identification du thread operant sur la zone
} St_MemZ;

// Les flags (bits) correspondant aux operations effectuees sur une zone
// Free->libre, Filled->rempli(par DMA), Saved(ecrit sur disque), Proc(Traitement)
// ProcA/B/C : Trois traitement qui doivent s'enchainer 
enum MemZStatus { MemZS_Free=0, MemZS_Filled=1, MemZS_Saved=2, MemZS_Proc=4, 
                  MemZS_ProcA=8, MemZS_ProcB=16, MemZS_ProcC=32 };
// L'action en cours sur une zone 
enum MemZaction { MemZA_None=0, MemZA_Fill=1, MemZA_Save=2, MemZA_Proc=4, 
                  MemZA_ProcA=8, MemZA_ProcB=16, MemZA_ProcC=32 };

// -------------------------------------------------------------------
// Classe de gestion de zones memoire partagee (des buffers) entre
// threads - qui doivent operer successivement sur les vecteurs
// -------------------------------------------------------------------
class RAcqMemZoneMgr {
public:
// Constructeur, nz=Nb de zones, np=Nb de paquets/zone , psz=taille de paquet
  RAcqMemZoneMgr(uint_4 nz, uint_4 np=256, uint_4 psz=4096);
  ~RAcqMemZoneMgr();
  
  // Retourne le nombre de zones memoire
  inline uint_4 NbZones() { return nzones; }
  // Retourne la taille de paquet
  inline uint_4 PaqSize() { return paqsz; }
  // Retourne le nb de paquets dans une zone
  inline uint_4 NbPaquets() { return npaq; }
  // Retourne la taille totale d'une zone 
  inline uint_4 ZoneSize() { return npaq*paqsz; }
  
  // Definit l'etat des operations obligatoires avant qu'une zone 
  // remplie ne puisse etre recyclee (re-remplie)
  inline uint_4 SetFinalizedMask(uint_4 mask=((uint_4)MemZS_Saved))
    { mask_finalized_ = mask; }
  inline uint_4 GetFinalizedMask() { return mask_finalized_; }

  // Retourne un MemZone disponible pour une action specifique
  int FindMemZoneId(MemZaction act);
  // Libere une zone memoire en marquant son etat
  int FreeMemZone(int id, MemZStatus st);
  // Retourne le pointeur de la zone numero k
  inline Byte* GetMemZone(int id)  {
    if ((id < 0) || (id >=(int) memzones.size()))  return NULL;
    return memzones[id];  
    }
  
  ostream& Print(ostream& os);
  void Stop(); 
        
protected:
  // ... variables membres
  ZMutex mex;   
  uint_4 nzones, npaq, paqsz;
//  DMAMgrInterface &dma_;
  vector< Byte* > memzones;
  vector< St_MemZ > states; 
  bool stop_;
  uint_4 mask_finalized_;
  uint_8 serial_;  
};




#endif
