#include <iostream>

#include "tmtacq.h"
#include "racqumem.h"
#include "racqurw.h"
#ifndef NOPCIECARD
#include "racquwbin.h"
#endif
#include "racquproc.h"


#include "pciewrap.h"
#include "brpaqu.h"
#include "minifits.h"

#include "resusage.h"
#include "ctimer.h"
#include "timing.h"

#include "tarrinit.h"
#include "fiosinit.h"

using namespace std;
using namespace SOPHYA;
	
static DataSaver *pDs;
static PCIEReaderChecker *pPcierc;
static PCIEReader *pPcier;
static DataProcFFT2C *pPrfft;
static DataProc2C *pPr;
static RAcqMemZoneMgr *pMmgr;
//--------------------------------------------------------
// Programme test acquisition BAORadio multi-thread 
//  LAL -   R. Ansari Juillet -  2008
//--------------------------------------------------------
void Stop(int s)
{
  printf("............. MAIN ... receive signal %d \n",s);
  if (pPcierc != NULL) pPcierc->Stop();
  if (pPcier != NULL) pPcier->Stop();
  if (pPr !=NULL) pPr->Stop();
  if (pPrfft !=NULL) pPrfft->Stop();
  if (pDs != NULL) pDs->Stop();
  if (pMmgr !=NULL) pMmgr->Stop();
  
}

int main(int narg, char* arg[])
{ 
  
 struct sigaction act;
 
  int rc = 0;
 cout << " ===============================================================" << endl;
  cout << " =========  " <<BAOR_ACQ_VER_STR <<BAOR_ACQ_VER <<"                  ===========" << endl;
  cout << " ===============================================================" << endl;
  
 if (narg < 8) {
   cout << "\n Usage: tmtacq CardNum PaquetSize NFrameDMA NFiles NBlocPerFile NMaxProc DataDirPath [AcqMode] [MemZoneMgr][HardCtlC]" << endl;
   cout << " - CardNum : PCI-Express card number (=1,2)" << endl;
   cout << " - PaquetSize or FrameSize (=DATA+HDR+TRL_Size)  " << endl;
   cout << " - NFrameDMA = DMASize= NFrameDMA*1024 , 4KO<=MaxDMASize<=64 ko " << endl;
   cout << " - NFiles = Number of data files produced " << endl;
   cout << " - NBlocPerFile = Number of memory data bloc in one file " << endl;
   cout << " - NMaxProc = Max number of memory data blocs processed (FFT ...) " << endl;
   cout << "      NMaxProc=0 -> No Processing " << endl;
   cout << " - DataDirPath : Subdirectory of /Raid " << endl;
   cout << "   Pour la version du firmware qui ne swappe pas les paquets" << endl;
   cout << " - AcqMode: = swapall , fft1c , fft2c, swh , nof , mxs , mono , monosw (default=std)" << endl;
   cout << "    swapall -> SwapAll+SaveData , swh->swap header only " << endl;
   cout << "    fft1c , ff2c -> reorder data for 1 channel/2channel FFT " << endl;
   cout << "    fft1cnof , ff2cnof -> reorder FFT data, but DONT write files " << endl;
   cout << endl;
   cout << "   Pour la version du firmware qui swappe partiellement " << endl;
   cout << "  -AcqMode : swap32 ,fft1c32 , fft2c32,fft1cnof32 , fft2cnof32 " <<endl;
   cout << "    fft1c32 , fft2c32 -> reorder data for 1 channel/2channel FFT " << endl;
   cout << "    fft1cnof32 , ff2cnof32 -> reorder FFT data, but DONT write files " << endl << endl;
 cout << endl;
   cout << "   Pour la version du firmware qui ne swappe plus " << endl;
   cout << "  -AcqMode :  nosw,fft1cnosw , fft2cnosw" <<endl;
   cout << "    fft1cnosw , fft2cnosw -> reorder data for 1 channel/2channel FFT " << endl;
   cout << "    fft1cnofnosw , ff2cnofnosw -> reorder FFT data, but DONT write files " << endl << endl;


   cout << "   Option pour debug ou test performance swapp initial (std)" << endl ;
   cout << "    nof->Don't write signal fits files , mxs->swh+nof: swap header only + no fits " << endl;
   cout << "    mono->Test with a single thread PCIEReaderChecker " << endl;
   cout << "   monosw->Test with a single thread PCIEReaderChecker, But swap all packet " << endl;
   cout << endl;
   cout << "   mononsw->Test with a single thread PCIEReaderChecker, But no swap paquet " << endl;
   cout << endl;
   cout << " - MemZoneMgr: nZones,NPaq =Number of Zones and number of paquet in each zone (Default=8,128) " << endl;
   cout << " -HardCtlC : Y y (direct interrpution by CtrlC ) default (no) " << endl;
  return 1;
  }

  InitTim();
 
  // Initialisation 
  TArrayInitiator _arri;
  FitsIOServerInitiator _fiosi;
  Timer tm("tmtacq");
 
  string acqmode = "std";
  if (narg > 8)  acqmode = arg[8];
  bool savesigfits = true;
  // BRDataFmtConv swapall = BR_SwapAll;
  BRDataFmtConv swapall = BR_Copy;
  bool monothr = false;
  if (acqmode == "swapall")  swapall = BR_SwapAll;
  if (acqmode == "fft1c")  swapall = BR_FFTOneChan;
  if (acqmode == "fft2c")  swapall = BR_FFTTwoChan;
  if (acqmode == "fft1cnof")  { swapall = BR_FFTOneChan;  savesigfits = false; }
  if (acqmode == "fft2cnof")  { swapall = BR_FFTTwoChan;  savesigfits = false; }
  if ((acqmode == "swh") || (acqmode == "mxs") || (acqmode == "mono") )  swapall = BR_SwapHDR;
  if ((acqmode == "nof") || (acqmode == "mxs") || (acqmode == "mono"))  savesigfits = false;
  if (acqmode == "mono")  { monothr = true;   swapall = BR_SwapHDR;; }
  if (acqmode == "monosw")  { monothr = true;   swapall = BR_SwapAll; }
  if (acqmode == "mononsw")  { monothr = true;   swapall = BR_Copy; }

  if (acqmode == "swap32")   swapall = BR_Swap32 ;
  if (acqmode == "fft1c32")  swapall = BR_FFTOneChan32;
  if (acqmode == "fft2c32")  swapall = BR_FFTTwoChan32;
  if (acqmode == "fft1cnof32")  { swapall = BR_FFTOneChan32;  savesigfits = false; }
  if (acqmode == "fft2cnof32")  { swapall = BR_FFTTwoChan32;  savesigfits = false; }

  if (acqmode == "nosw")   swapall = BR_Copy ;
  if (acqmode == "fft1cnosw")  swapall = BR_FFTOneChanNoSwap;
  if (acqmode == "fft2cnosw")  swapall = BR_FFTTwoChanNoSwap;
  if (acqmode == "fft1cnofnosw")  { swapall = BR_FFTOneChanNoSwap;  savesigfits = false; }
  if (acqmode == "fft2cnofnosw")  { swapall = BR_FFTTwoChanNoSwap;  savesigfits = false; }

#ifdef NOPCIECARD
  string dir = string(arg[7])+"/";
#else  
  string dir =string("/Raid/")+arg[7]+"/";
#endif 
  cout << "  DataDirpath=" << dir << " SwapMode=" << BRPaquet::FmtConvToString(swapall) 
       << "  DataSaveMode=" << ((savesigfits)?"Yes/FitsFile":"NO") << endl; 
  
  char cmd[192];
  sprintf(cmd,"mkdir %s",dir.c_str());
  if (system(cmd) < 0) {
    cout << "tmtacq/Error: Can not create  subdirectory " << dir << " -> exit" << endl;
    return 2;
  }
  int card = atoi(arg[1]);
  unsigned int sizeFrame = atoi(arg[2]);
  unsigned int nbFrameDMA = atoi(arg[3]);
  int NbFiles = atoi(arg[4]);
  int NBlocPerFile = atoi(arg[5]);
  int NMaxProc = atoi(arg[6]);  // Nombre de blocs traites par le thread de calcul
  cout << "tmtacq[1] - starting acq program under card " << card <<  " FrameSize= " << sizeFrame << endl;

  uint_4 nZones = 8;  // Nombre de zones memoires
  uint_4 nPaqZone = 128;  // 128 Paquets / zone memoire - valeur par defaut
  if (narg > 9)  { 
    int ia1, ia2;
    sscanf(arg[9],"%d,%d", &ia1, &ia2);
    nZones = ia1;  nPaqZone = ia2; 
  }

  bool fg_hard_ctrlc = false;
  if (narg > 10)    // pour traiter eventuellement un arret brutal par CtlC mettre le 10eme arg a Y
    if ((*arg[10]=='y')||(*arg[10]=='Y'))  fg_hard_ctrlc=true;
  if (!fg_hard_ctrlc) {
    act.sa_handler=Stop;
    sigaction(SIGINT,&act,NULL);  	
  }

  uint_4 PaqSZ =sizeFrame;  // Taille de paquets 
  // uint_4 dmaSize  = nbFrameDMA*PaqSZ ;  // plantage 
  uint_4 dmaSize  = nbFrameDMA*1024 ; 
  uint_4 patternSZ=0x400;  // pas utilise avec la fibre 
  uint_4 NMaxBloc = NbFiles*NBlocPerFile; 
  cout << "tmtacq[0] - PaqSize = " << PaqSZ << " NbPaq/Zone=" << nPaqZone << " NZones=" << nZones << endl; 
  cout << " NbFiles=" << NbFiles << " NBloc/File=" << NBlocPerFile << " -> NMaxBloc=" << NMaxBloc << endl;
  cout << "tmtacq[1] NbFrameDMA=" << nbFrameDMA << "  DMASize=" << dmaSize << " bytes" << endl;
  cout << "tmtacq[1] NMaxProc=" << NMaxProc << endl;
  try {

#ifdef NOPCIECARD
    TestPCIWrapperNODMA pciw(PaqSZ);
#else
    DMAMgr dma1(card,patternSZ,dmaSize ); 
    if (! dma1.StatusFibre() ) {
      cout << " tmtacq[0] - fibre non accrochee -> exit " << endl;
      throw PCIEWException(" Fibre non accrochee ");
    }
    else cout << " tmtacq[0] - fibre accrochee OK " << endl;
#endif    
    RAcqMemZoneMgr mmgr(nZones, nPaqZone, PaqSZ);
    pMmgr =&mmgr;

    if (monothr) {
      cout << "tmtacq[1] single thread PCIE test PCIEReaderChecker ... ";
      PCIEReaderChecker pcirc(pciw,dmaSize,PaqSZ ,mmgr, NMaxBloc, swapall);
      pPcierc=&pcirc;
      pcirc.start();
      sleep(1);
      pcirc.join();
      cout << "tmtacq[2] - single thread PCIEReaderChecker finished " << endl;
      tm.Split("Single Thread Finished");  
      mmgr.Print(cout);
      return 0;
    }
    PCIEReader pcir(pciw,dmaSize,PaqSZ ,mmgr, NMaxBloc, swapall);
    pPcier= &pcir;
     DataSaver ds(mmgr, dir, NbFiles, NBlocPerFile, savesigfits);
     pDs= &ds;
     //DataBinSaver ds(mmgr, dir, NbFiles ,NBlocPerFile);
     //     DataProc1C pr(mmgr, dir, nmean, stepproc, 100);     Pour processer un canal
     int stepproc = 2;
     int nmean = nPaqZone*NBlocPerFile/stepproc;
     DataProc2C pr(mmgr, dir, nmean, stepproc, NMaxProc);
     DataProcFFT2C prfft(mmgr, dir, nmean, stepproc, NMaxProc);
    tm.Split("Threads created");  
    cout << "tmtacq[2] - starting 3 threads pcir, ds, pr ... " << endl;
    /*
    char test[100];
    cout << " <CR> to continue, x to exit ..." << endl;
    gets(test); if (test[0] == 'x')  return 9;
    */
    pcir.start();
    ds.start();
    if (NMaxProc>0) { // On ne demarre que si au moins NMaxProc>0
      if (acqmode.substr(0,5)=="fft2c")	{ prfft.start(); pPrfft=&prfft;}
      else { pr.start();   pPr=&pr;}
    }
    cout << "tmtacq[3] - waiting for threads to finish ... " << endl;
    sleep(1);
    pcir.join();
    ds.join();
    sleep(1);
    mmgr.Stop();
   if (NMaxProc>0) if ( pPr != NULL) pr.join();
   if (NMaxProc>0) if ( pPrfft != NULL) prfft.join();
    cout << "tmtacq[4] - threads finished " << endl;
    tm.Split("Threads Finished");  
    mmgr.Print(cout);
    rc = 0;
  }
  catch (MiniFITSException& exc) {
    cerr << " tmtacq.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  } 
  catch (PCIEWException& exc) {
    cerr << "\7  tmtacq.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 75;
  }  
  catch (PThrowable& exc) {
    cerr << " tmtacq.cc catched Exception " << exc.Msg() << endl;
    rc = 76;
  }  
  catch (std::exception& sex) {
    cerr << "\n tmtacq.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
  	cerr << "  tmtacq.cc : Catched ... exception " << endl;
  	rc = 79;
  }
  cout << "tmtacq[9] - stopping acq program " << endl;
  return rc;
}

