// auxinterpgps.h
// Eric Aubourg         CEA/DAPNIA/SPP   aout 1999

#ifndef AUXINTERPGPS_H
#define AUXINTERPGPS_H

#include "auxgps.h"
#include <set>
#include <string>

using namespace std;

class AuxInterpGPS : public AuxGPS {
public:
  AuxInterpGPS();
  virtual int getLocation(double mjd, double& lat, double& lon, double& alt);
  
  void FitsDump(string const& filename);
  virtual AuxGPS* clone() {return new AuxInterpGPS(*this);}

protected:
  virtual void AddValue(double mjd, double lat, double lon, double alt);
  virtual void FindElem(double mjd);

  struct elem {
     elem() {}
     elem(double m, double la, double lo, double a)
      : mjd(m), lat(la), lon(lo), alt(a) {}
     double mjd;
     double lat;
     double lon;
     double alt;
     bool operator == (elem const& x) const {return mjd == x.mjd;}
     bool operator < (elem const& x) const {return mjd < x.mjd;}
  };
  
  set<elem> elems;
  set<elem>::const_iterator ilast;
  bool ilastok;
};

#endif
