// tsid.h
// Eric Aubourg         CEA/DAPNIA/SPP   aout 1999
// adapted from TSid.java, E. Aubourg 1998.

#ifndef TSID_H
#define TSID_H

#include <map>

using namespace std;

class TSid {
public:
  TSid(double longitude=0);               // en degres, E = +
  
  void setLongitude(double longitude);    // en degres, E = +
  double getLST(double mjd);              // en secondes
 
protected:
  map<double, double> dut1;
  void InitDUT();
  double longitude;
  double getDUT1(double mjd);             // UT1-UTC, secondes
  static const double SIDRATE;
  static const double MJDRef;
};

#endif
