//----------------------------------------------------------------
// ---- classes de threads pour lecture fichiers minifits
// LAL -      R. Ansari - Mai 2009 
//----------------------------------------------------------------


#include "brfitsrd.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>
#include <signal.h>
#include "pexceptions.h"
#include "timestamp.h"
#include "ctimer.h"

#include "brpaqu.h"
#include "minifits.h"

#include "resusage.h" // Pour mesure temps elapsed/CPU ...
#include "datatable.h" // Pour sauver les entetes de paquet 
#include <sys/time.h>  // pour gettimeofday

//-------------------------------------------------------
// Classe thread de sauvegarde sur fichiers
//-------------------------------------------------------

BRFitsReader::BRFitsReader(RAcqMemZoneMgr& mem, vector<string>& infiles, bool fgnotrl)
  :  memgr(mem), infiles_(infiles), fgnotrl_(fgnotrl)
{
}
void BRFitsReader::Stop()
{
  // cout<< " BRFitsReader:Stop ........ " << endl;
  stop_=true;
}
void BRFitsReader::run()
{
  setRC(1);	
  BRPaqChecker pcheck;  // Verification/comptage des paquets 

  try {
    TimeStamp ts; 
    Timer tm("BRFitsReader");
    size_t totnbytesrd = 0;
    cout << " BRFitsReader::run() - Starting " << ts << " NbFiles=" << infiles_.size() 
         << "  memgr.PaqSize() = " << memgr.PaqSize() << endl;

    uint_4  nfileok = 0; 
    uint_8 nbytesrd = 0;  
    for(int ifile=0; ifile<infiles_.size(); ifile++) {
      string ffname = infiles_[ifile];
// -------------- Lecture de bytes      
      cout << "BRFitsReader::run() [" << ifile <<"]Ouverture/lecture fichier " << ffname << endl;
      MiniFITSFile mff(ffname, MF_Read);
      cout << "... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
  	   << " NAxis2=" << mff.NAxis2() << endl;
      if (mff.DataType() != MF_Byte) {
        cout << "BRFitsReader::run() PB : DataType!=MF_Byte --> skipping " << endl;
        continue;
      }
// Les fichier FITS contiennent l'entet (24 bytes), mais pas le trailer (16 bytes) si fgnotrl=true
      int incpaqsz=0;
      int paqsz = 0;
      if (fgnotrl_) {
        incpaqsz=16;
        cout << " Warning : FITS files without frame trailers ..." << endl;
      }
      if (paqsz == 0)  {  // premier passage, on fixe la taille de paquet et on alloue le buffer
        paqsz = mff.NAxis1()+incpaqsz;
        if (paqsz != memgr.PaqSize()) {
         cout << "BRFitsReader::run() mff.NAxis1() incompatible with memgr.PaqSize() -> exception " << endl;
         throw SzMismatchError(" fits file size incompatible with memgr.PaqSize()"); 
        }
       if (mff.NAxis2() != memgr.NbPaquets())  {
         cout << "BRFitsReader::run() mff.NAxis2() <> memgr.NbPaquets() -> exception " << endl;
         throw SzMismatchError(" fits file NAxies2() <> memgr.NbPaquets()"); 
        }
      }
      else {
        if (paqsz != mff.NAxis1()+incpaqsz) {
        cout << " PB : paqsz=" << paqsz << " != mff.NAxis1()+" << incpaqsz << " --> skipping " << endl;
        continue;
        }
        if (memgr.NbPaquets() != mff.NAxis2()) {
        cout << " PB memgr.NbPaquets() != mff.NAxis2()  --> skipping " << endl;
        continue;
        }
      }
      int mid = memgr.FindMemZoneId(MemZA_Fill);  
      Byte* buff = memgr.GetMemZone(mid);
      if (buff == NULL) {
	cout << " BRFitsReader::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
	setRC(2);	
	return;	
      }
      size_t sx = mff.NAxis1(); 
      size_t sy = mff.NAxis2();
      
      for(int j=0; j<mff.NAxis2(); j++) {
        mff.ReadB(buff+j*paqsz, sx, j*sx);
	BRPaquet paq(NULL, buff+j*paqsz, paqsz);
	pcheck.Check(paq);   // Verification du paquet / FrameCounter 

      }
      nfileok++;   
      size_t nbytesrd = sx*sy;
      totnbytesrd += nbytesrd;
      memgr.FreeMemZone(mid, MemZS_Filled);
    }   // Fin de la boucle sur les fichiers


//    sprintf(fname,"%s/.log",path_.c_str());
//    ofstream filog(fname);
//    filog << " DataProc::run() - starting log file " << ts << endl;		       
//    filog << " NbFiles=" << nfiles_ << " NBloc/File="  << nblocperfile_ << " NMaxMemZones=" << nmax_ << endl;
    	


    cout << " ------------------  BRFitsReader::run() END ----------------- " << endl;
    ts.SetNow();
    tm.Split();
    cout << "  END reading " << ts << " NFileOK=" << nfileok << endl; 
    cout << "  TotalDiskRead= " << totnbytesrd/(1024*1024) << " MBytes Disk-Read rate= " 
         << (double)(totnbytesrd)/1024./tm.PartialElapsedTimems() << " MB/s" << endl;    
    pcheck.Print(cout);
    cout << " ---------------------------------------------------------- " << endl;

  }  // Fin du bloc try 
  catch (MiniFITSException& exc) {
    cout << " BRFitsReader::run()/catched MiniFITSException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " BRFitsReader::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   
