#ifndef  BRPAQU_H_SEEN
#define  BRPAQU_H_SEEN

/* ----------------------------------------
     Projet BAORadio --- LAL 
     Juin 2008 , M.Taurigna , R. Ansari 
-------------------------------------------  */

#include <stdio.h>
#include <iostream>
#include <string>
#include "brtypes.h"


using namespace std;

// ------------------------------------------------
// ----- Classe TwoByteComplex ------
// On definit une classe TwoByteComplex() pour manipuler une paire de byte 
// representant partie relle et imaginaire d'un nombre complexe
// Remarque Byte = unsigned char 
// Remarque SByte = char = signed char 
class TwoByteComplex {
 public:
  explicit TwoByteComplex() { val_[0] = val_[1] = 0; }
  //  explicit TwoByteComplex(TwoByteComplex const & a) { val_[0] = a.val_[0]; val_[1] = 0; }
  explicit TwoByteComplex(Byte re, Byte im) { val_[0] = re; val_[1] = im; }
  explicit TwoByteComplex(SByte re, SByte im) { val_[0] = re; val_[1] = im; }
  explicit TwoByteComplex(int re, int im) { val_[0] = re; val_[1] = im; }
  explicit TwoByteComplex(float re, float im) { val_[0] = re; val_[1] = im; }
  explicit TwoByteComplex(double re, double im) { val_[0] = re; val_[1] = im; }
  
  inline Byte& realB() { return  val_[0]; }
  inline Byte& imagB() { return  val_[1]; }

  inline SByte realSB() { return  ((SByte*)val_)[0]; }
  inline SByte imagSB() { return  ((SByte*)val_)[1]; }

  inline int realI() { return  ((SByte*)val_)[0]; }
  inline int imagI() { return  ((SByte*)val_)[1]; }

  inline double realD() { return  ((SByte*)val_)[0]; }
  inline double imagD() { return  ((SByte*)val_)[1]; }

  Byte val_[2];
};

// ------------------------------------------------

// OFFSET : au cas ou le firmware reception ajoute des mots avant le header 
#define OFFSET 0 
// Taille entete/trailer en octets 
#define BRHDRSIZE 24
// Actuellement le trailer est vire ...
// Reza, 28 Jan 2009  le trailer fait 16 octets 
#define BRTRLSIZE 16  
/* REZA passe a 16 octets  #define BRTRLSIZE 40 */
//Offset Mode Acq 
#define BRMODACQOFF  20 /*RezaMOD #define BRMODACQOFF  24 */
// Offset ChanId
#define BRCHANIDOFF 20 /*RezaMOD #define BRCHANIDOFF 24 */
// Offset du time-tag
#define BRTMTAGOFF 12 /*RezaMOD #define BRTMTAGOFF 16 */
// offset FrameCounter
#define BRFRCPTOFF 16 /*RezaMOD#define BRFRCPTOFF 20 */
// offset Paquet Id 
#define BRPKTIDOFF 20  /*RezaMOD #define BRPKTIDOFF 24 */
// offset paquet lenght = FrameDataLength 
#define BRPKTLENOFF 8 /*RezaMOD #define BRPKTLENOFF 12 */
// offset position chariot ???
//#define BRPCOFF 16

enum ChannelID
  {
    None=0,
    Ch1,
    Ch2,
    Ch1_2,
    Ch3,
    Ch4,
    Ch3_4
  };
enum ModeAcq
  {
    RawData=1,
    FFT
  };

// Definition des actions sur la conversion de format (swap...) des donnees arrivant
enum BRDataFmtConv {
  BR_DoNothing,
  BR_Copy,
  BR_SwapAll,
  BR_SwapHDR,
  BR_FFTOneChan,
  BR_FFTTwoChan,
  BR_Swap32,
  BR_FFTOneChan32,
  BR_FFTTwoChan32,
  BR_FFTOneChanNoSwap,
  BR_FFTTwoChanNoSwap
};

// Structure correspondant a HEADER-DATA-TRAILER
class BRPaquet {
 public:
// Cree d'un objet BRPaquet avec copie/swap depuis src -> dst (si src != NULL)
  BRPaquet(Byte* src, Byte* dst, int paqsz=4096, BRDataFmtConv fgswap=BR_SwapAll);
// Cree d'un objet BRPaquet de taille paqsz sur la zone dst   
  BRPaquet(Byte* srcdst, int paqsz=4096);
//  ~BRPaquet();

  // Acces diverses tailles 
  inline int PaquetSize() { return sz_; }
  inline int DataSize() { return sz_-(BRHDRSIZE+BRTRLSIZE); }
  inline int HeaderSize() { return BRHDRSIZE; }
  inline int TrailerSize() { return BRTRLSIZE; }

  // Acces differentes zone memoire
  inline Byte* Begin() { return dst_+OFFSET; }
  inline Byte* Data1() { return dst_+BRHDRSIZE+OFFSET; }
  inline Byte* Data2() { return dst_+BRHDRSIZE+(DataSize()/2)+OFFSET; }
  inline Byte* Header() { return dst_+OFFSET; }
  inline Byte* Trailer() { return (dst_+sz_-BRTRLSIZE+OFFSET); }
  
  // Valeurs differentes zones HDR/TRL
  inline UInt32 HDRMarker() {return *((UInt32*)(dst_+OFFSET));}
  inline UInt32 HDRMarker2() {return *((UInt32*)(dst_+OFFSET+1));}
  inline UInt64 HDRMarker64() {return *((UInt64*)(dst_+OFFSET));}

  inline UInt32 TRLMarker() {return *((UInt32*)(dst_+(sz_-BRTRLSIZE+OFFSET)));}
  inline UInt32 TRLMarker2() {return *((UInt32*)(dst_+(sz_-BRTRLSIZE+OFFSET+1)));}
  inline UInt64 TRLMarker64() {return *((UInt64*)(dst_+(sz_-BRTRLSIZE+OFFSET)));}

// Informations diverses sur le paquet/mode d'acquisition
  inline UInt16 ModeAcq()   {return *((UInt16*)(dst_+(BRMODACQOFF+OFFSET)));}
  inline UInt16 ChanId()    {return (( *((UInt16*)(dst_+(BRCHANIDOFF+OFFSET))) & 0x1800)>> 12) ;}
  inline UInt16 ChipId()    {return (( *((UInt16*)(dst_+(BRCHANIDOFF+OFFSET))) & 0xC00)>> 10) ;}

  inline UInt32 FrameCounter()   {return ((*((UInt32*)(dst_+(BRFRCPTOFF+OFFSET))) &0xFFFF0000) >> 16);}
  inline UInt32 TimeTag1()   {return *((UInt32*)(dst_+(BRTMTAGOFF+OFFSET)));}
  inline UInt32 TimeTag2() {return (*((UInt32*)(dst_+(BRFRCPTOFF+OFFSET))) &0xFFFF);}
  inline UInt64 TimeTag() {return (*((UInt64*)(dst_+(BRTMTAGOFF+OFFSET))) &0x0000FFFFFFFFFFFFULL);}

  inline UInt32 PaqId()     {return *((UInt32*)(dst_+(BRPKTIDOFF+OFFSET)));}
  inline UInt16 PaqLen()    {return *((UInt16*)(dst_+(BRPKTLENOFF+OFFSET)));}

  UInt16  ChannelID();
  UInt16  ModeAcquisition();

  // inline unsigned short PositionChariot() {return *((unsigned short*)(dst_+BRPCOFF+OFFSET));}
  // Fonctions utiles pour remplir un objet BRPaquet 
  void SetHDRMarker64(UInt64 htag); 
  void SetTRLMarker64(UInt64 ttag); 
  void SetFrameCounter(UInt32 fc);  
  void SetTimeTag(UInt64 timtag);
  inline void SetPaqLen(UInt16 len) { *((UInt16*)(dst_+(BRPKTLENOFF+OFFSET))) = len; }

  // pour faire un print de la structure
  ostream& Print(ostream & os, int nelt=8, bool prht=true);
  inline ostream& Print(int nelt=8, bool prht=true)
    { return Print(cout, nelt, prht); }

  // fonction appelee par le constructeur pour reordonner les donnees FFT 
  static void ReorderFFTData(Byte* src, Byte* dst, int sz);
  static void ReorderFFTData32(Byte* src, Byte* dst, int sz);
  static void ReorderFFTDataNoSwap(Byte* src, Byte* dst, int sz);
  static const char* FmtConvToString(BRDataFmtConv fgswap);
// protected:
  // donnees membres
  int sz_; //taille du paquet 
  Byte* dst_;  
};

// --------------------------------------------------------------------------
// Classe pour effectuer des verifications d'integrite sur les paquets/frames
// --------------------------------------------------------------------------

class BRPaqChecker {
public: 
  BRPaqChecker();
  ~BRPaqChecker();

  UInt64 DefineHDRTag(UInt32 hdr1=0x76543210, UInt32 hdr2=0xFEDCBA98);
  UInt64 DefineTRLTag(UInt32 trl1=0x55555555, UInt32 trl2=0xAAAAAAAA);
  
  inline UInt64 HDRTag() { return hdrtag_; }
  inline UInt64 TRLTag() { return trltag_; }

  // Verifie le paquet, renvoie true si OK
  bool Check(BRPaquet& paq);
  // Imprime le compte de paquets ... 
  ostream & Print(ostream& os);

  unsigned long long totnframes;    // Nombre totale de frames/paquets traites 
  unsigned long long  nframeok;     // Nombre totale de frames/paquets avec HDR/TRL OK
  unsigned long long lostframes;    // Nombre totale de frames/paquets perdus 
  unsigned int frclst;         // derniere valeur du frame-counter 

  UInt64 hdrtag_;
  UInt64 trltag_; 
};

#endif
 
 
