#include "racquproc.h"

#include <stdlib.h>
#include <unistd.h>
#include <fstream>
#include <signal.h>

#include "pexceptions.h"
#include "tvector.h"
#include "fioarr.h"
#include "timestamp.h"
#include "ctimer.h"
#include "fftpserver.h"
#include "fftwserver.h"

#include "FFTW/fftw3.h"


#include "pciewrap.h"
#include "brpaqu.h"
#include "brproc.h"


//---------------------------------------------------------------
// Classe thread de traitement donnees ADC avec 2 voies par frame
//---------------------------------------------------------------

BRProcARaw2C::BRProcARaw2C(RAcqMemZoneMgr& mem, string& path, uint_4 nmean, uint_4 step, uint_4 nmax)
  :  memgr(mem) 
{
  nmax_ = nmax;	
  nmean_ = nmean;
  step_ = step;
  stop_ = false;	
  path_ = path;	
}

void BRProcARaw2C::Stop()
{
 stop_=true;
 // cout <<" BRProcARaw2C::Stop ... > STOP " << endl;
}


static inline r_4 Zmod2(complex<r_4> z) 
{ return (z.real()*z.real()+z.imag()*z.imag()); }

void BRProcARaw2C::run()
{
  setRC(1);	
  try {
    Timer tm("BRProcARaw2C");
    TimeStamp ts; 
    cout << " BRProcARaw2C::run() - Starting " << ts << " NMaxMemZones=" << nmax_ 
	 << " NMean=" << nmean_ << " Step=" << step_ << endl;	
    cout << " BRProcARaw2C::run()... - Output Data Path: " << path_ << endl;
    char fname[512];
//    sprintf(fname,"%s/proc.log",path_.c_str());
//    ofstream filog(fname);
//    filog << " BRProcARaw2C::run() - starting log file " << ts << endl;		       
//    filog << " ... NMaxMemZones=" << nmax_ << " NMean=" << nmean_ << " Step=" << step_ << endl;	

// Initialisation pour calcul FFT 
    TVector< complex<r_4> > cfour;  // composant TF
    uint_4 paqsz = memgr.PaqSize();
    uint_4 procpaqsz = memgr.ProcPaqSize();
    BRPaquet pq(NULL, NULL, paqsz); 
    TVector<r_4> vx(pq.DataSize()/2);
    vx = (r_4)(0.);
    FFTPackServer ffts;
    ffts.FFTForward(vx, cfour);
    TVector<r_4> spectreV1, spectreV2;
  
    spectreV1.ReSize(cfour.Size());
    spectreV2.ReSize(cfour.Size());
    
    TVector< complex<r_4> > visiV12( cfour.Size() );


    uint_4 ifile = 0;  			        
    uint_4 nzm = 0;
    for (uint_4 kmz=0; kmz<nmax_; kmz++) {
      if (stop_) break;
      int mid = memgr.FindMemZoneId(MemZA_ProcA);
      Byte* buff = memgr.GetMemZone(mid);
      if (buff == NULL) {
  	cout << " BRProcARaw2C::run()/ERROR memgr.GetMemZone(" << mid << ") -> NULL" << endl;
  	break;		
      }
      Byte* procbuff = memgr.GetProcMemZone(mid);
      if (procbuff == NULL) {
  	cout << " BRProcARaw2C::run()/ERROR memgr.GetProcMemZone(" << mid << ") -> NULL" << endl;
  	break;	
      }
      BRPaquet paq0(NULL, buff, paqsz); 
      for(uint_4 i=0; i<memgr.NbPaquets(); i+=step_) {
  	BRPaquet paq(NULL, buff+i*paqsz, paqsz); 
  	Byte min = 255;
  	Byte max = 0;
 
// Traitement voie 1  	    
  	for(sa_size_t j=0; j<vx.Size(); j++) 
  	  vx(j) = (r_4)(*(paq.Data1()+j))-127.5;
        fftwf_complex* coeff1 = (fftwf_complex*)(procbuff+i*procpaqsz);
        fftwf_plan plan = fftwf_plan_dft_r2c_1d(vx.Size(), vx.Data(), coeff1, FFTW_ESTIMATE); 
  	fftwf_execute(plan); 
        //   ffts_.FFTForward(vx, cfour_);
        complex<r_4>* zp1 = (complex<r_4>*)(coeff1);
        for(sa_size_t j=0; j<spectreV1.Size(); j++) 
          spectreV1(j) += Zmod2(zp1[j]);
 
// Traitement voie 2  	    
   	for(sa_size_t j=0; j<vx.Size(); j++) 
 	  vx(j) = (r_4)(*(paq.Data2()+j))-127.5;
        fftwf_complex* coeff2 = (fftwf_complex*)(procbuff+i*procpaqsz+procpaqsz/2);
        plan = fftwf_plan_dft_r2c_1d(vx.Size(), vx.Data(), coeff2, FFTW_ESTIMATE); 
  	fftwf_execute(plan); 
        //    ffts_.FFTForward(vx, cfour_);
        complex<r_4>* zp2 = (complex<r_4>*)(coeff2);
        for(sa_size_t j=0; j<spectreV2.Size(); j++) 
          spectreV2(j) += Zmod2(zp2[j]); 

// Calcul correlation (visibilite V1 * V2)
        for(sa_size_t j=0; j<visiV12.Size(); j++) visiV12(j)+=zp1[j]*zp2[j];

        nzm++;
      }
      if ((nzm >= nmean_) ||(kmz==(nmax_-1))) {
        spectreV1 /= (r_4)(nzm);
        spectreV2 /= (r_4)(nzm);

        visiV12 /= complex<r_4>((r_4)nzm, 0.);

        spectreV1.Info()["NPaqMoy"] = nzm;
        spectreV2.Info()["NPaqMoy"] = nzm;
        visiV12.Info()["NPaqMoy"] = nzm;
	{
    	sprintf(fname,"%s_%d.ppf",path_.c_str(),(int)ifile);
        POutPersist po(fname);
        po << PPFNameTag("specV1") << spectreV1; 
        po << PPFNameTag("specV2") << spectreV2; 
        po << PPFNameTag("visiV12") << visiV12; 
	}
        spectreV1 = (r_4)(0.);
        spectreV2 = (r_4)(0.);
        visiV12 = complex<r_4>(0., 0.);
        nzm = 0;  ifile++; 
//        ts.SetNow();
//        filog << ts << " :  proc file  " << fname << endl;		       
        cout << " BRProcARaw2C::run() created file  " << fname << endl;
      }
      
      memgr.FreeMemZone(mid, MemZS_ProcA);
    }
  }
  catch (PException& exc) {
    cout << " BRProcARaw2C::run()/catched PException " << exc.Msg() << endl;
    setRC(3);	
    return; 
  }
  catch(...) {
    cout << " BRProcARaw2C::run()/catched unknown ... exception " << endl;
    setRC(4);	
    return; 
  }
  setRC(0);
  return;
}   




