// Utilisation de SOPHYA pour faciliter les tests ...
#include "sopnamsp.h"
#include "machdefs.h"

/* ---------------------------------------------------------- 
   Programme de lecture multi canaux pour BAORadio  
   R. Ansari, C. Magneville
   V : Mai 2009
   ---------------------------------------------------------- */

// include standard c/c++
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <iostream>
#include <string>

#include "pexceptions.h"
#include "tvector.h"
#include "fioarr.h"
#include "tarrinit.h" 
#include "timestamp.h"
#include "fftpserver.h"
#include "fftwserver.h"

#include "FFTW/fftw3.h"

// include sophya mesure ressource CPU/memoire ...
#include "resusage.h"
#include "ctimer.h"
#include "timing.h"


// include mini-fits lib , et structure paquet BAORadio
#include "minifits.h"
#include "brpaqu.h"
#include "brfitsrd.h"
#include "brproc.h"


//--- Fonctions de ce fichier 
int DecodeMiniFitsHeader(string& filename, uint_4& paqsz, uint_4& npaq, bool fgnotrl=false) 
{
  MiniFITSFile mff(filename, MF_Read);
  cout << "DecodeMiniFitsHeader()... Type=" << mff.DataTypeToString() << " NAxis1=" << mff.NAxis1() 
       << " NAxis2=" << mff.NAxis2() << endl;
  paqsz = mff.NAxis1();
  npaq = mff.NAxis2();
  if (fgnotrl)  paqsz += 16;
  return 0;
}

//----------------------------------------------------
//----------------------------------------------------
int main(int narg, char* arg[])
{
  if (narg < 4) {
    cout << " --- Reading/Processing BAORadio FITS files" << endl;
    cout << " Usage:  mcrd ACT OutPPF -infits DirName Imin Imax " << endl;
    cout << " ACT= notrl FITS files without frame trailer \n" 
         << " OutPPF : Output PPF file name (without .ppf)" << endl;
    cout << " -infiles DirName Imin Imax : Input fits directory and sequence numbers \n" 
         << "    FileNames=DirName/signalII.fits Imin<=II<=Imax " << endl;  
    return 1;
  }

  TArrayInitiator  _inia;

  int rc = 0;
  try {
    string act = arg[1];
    string outname = arg[2];
    vector<string> infiles;
    if ((strcmp(arg[3],"-infits")!=0) || (narg<7)) {
        cout << " mcrd/Error arguments - type mcrd for help" << endl;
        return 2;
    }
    char nbuff[1024];
    char* dirname = arg[4]; 
    int imin = atoi(arg[5]);
    int imax = atoi(arg[6]);
    for(int ii=imin; ii<=imax; ii++) {
      sprintf(nbuff,"%s/signal%d.fits",dirname,ii);
      infiles.push_back(nbuff);
    }

    cout << " ---------- mcrd.cc Start - ACT= " << act << " ------------- " << endl;
    ResourceUsage resu;
    bool fgnotrl=false;   // fichier fits avec Trailer de frame (> mai 2009)
    if (act=="notrl") fgnotrl=true;  // fichier fits SANS trailer 

    uint_4 paqsz, npaq;
    DecodeMiniFitsHeader(infiles[0],paqsz, npaq, fgnotrl); 

    int nzones = 3;
    RAcqMemZoneMgr mmgr(nzones, npaq, paqsz, sizeof(complex<r_4>)*paqsz);
    mmgr.SetFinalizedMask((uint_4)MemZS_ProcA);

    BRFitsReader reader(mmgr, infiles, fgnotrl);
    BRProcARaw2C proc(mmgr, outname, npaq, 1, npaq*infiles.size());

    cout << " mcrd.cc : Starting threads (reader, proc) ... " << endl;
    reader.start();
    proc.start();
    sleep(1);
    cout << " mcrd.cc : Waiting for reader thread to finish ... " << endl;
    reader.join();
    cout << " mcrd.cc : Reader finished, waiting for process thread to finish ... " << endl;
    sleep(2);
    mmgr.Stop();
    proc.join();
    mmgr.Print(cout);
    cout << resu ; 
  }
  catch (MiniFITSException& exc) {
    cerr << " mcrd.cc catched MiniFITSException " << exc.Msg() << endl;
    rc = 77;
  }  
  catch (std::exception& sex) {
    cerr << "\n mcrd.cc std::exception :" 
         << (string)typeid(sex).name() << "\n msg= " 
         << sex.what() << endl;
    rc = 78;
  }
  catch (...) {
    cerr << " mcrd.cc catched unknown (...) exception  " << endl; 
    rc = 79; 
  } 

  cout << ">>>> mcrd.cc ------- FIN ----------- RC=" << rc << endl;
  return rc;

}
