#include <stdlib.h>
#include <string.h>

#include "burawstream.h"
#include "sopnamsp.h"
#include "pexceptions.h"

/*!
   \class SOPHYA::RawInOutBuffStream
   \ingroup SysTools
   This class implements the interface defined by RawInOutStream 
   over a socket (read and write operations)
*/

#define SWRB_SIZE 1024 /* Taille des buffers I/O */

/* --Methode-- */
RawInOutBuffStream::RawInOutBuffStream(const char * nom)
  : RawInOutStream() 
{
  _fip = fopen(nom, "w+b");
  _rdbuff.buff = new char[SWRB_SIZE];
  _rdbuff.sz = SWRB_SIZE;
  _rdbuff.cpos = SWRB_SIZE;

  _wrbuff.buff = new char[SWRB_SIZE];
  _wrbuff.sz = SWRB_SIZE;
  _wrbuff.cpos = 0;
  _totnwr = 0;
  _totnrd = 0;
}

/* --Methode-- */
RawInOutBuffStream::~RawInOutBuffStream()
{
  cout << " ---- DESTRUCTEUR ---- ~RawInOutBuffStream() " << endl;
  if (_wrbuff.cpos > 0) {
    for (size_t k= _wrbuff.cpos; k<_wrbuff.sz; k++)
      _wrbuff.buff[k] = '\0';
    _wrbuff.cpos = _wrbuff.sz;
    SendBuffer();
  }
  fclose(_fip);
  delete [] _rdbuff.buff;
  delete [] _wrbuff.buff;
}

/* --Methode-- */
size_t RawInOutBuffStream::CopyToSendBuffer(const char* s, size_t n)
{

  size_t len = _wrbuff.sz-_wrbuff.cpos;
  if (len > n) len = n;
  if ( (_wrbuff.cpos == 0) && (len == _wrbuff.sz) ) {
    cout << "RawInOutBuffStream::CopyToSend/DBG-1 - n=" 
	 << n << " len=" << len << endl;
    Send(s, len);
  }
  else {
    cout << "RawInOutBuffStream::CopyToSend/DBG-2 - n=" 
	 << n << " len=" << len << " cpos=" << _wrbuff.cpos << endl;
    memcpy(_wrbuff.buff+_wrbuff.cpos, s, len);
    cout << " memcpy OK - cpos= " << _wrbuff.cpos << endl;
    _wrbuff.cpos += len;
    if (_wrbuff.cpos == _wrbuff.sz)  SendBuffer();
  }
  return len;
}

/* --Methode-- */
size_t RawInOutBuffStream::CopyFromRecvBuffer(char* s, size_t n)
{
  if ( (_rdbuff.cpos == _rdbuff.sz) && ( n >= _rdbuff.sz)) {
    size_t len = _rdbuff.sz;
    cout << "RawInOutBuffStream::CopyFromRecv/DBG-1 - n=" << n 
	 << " len=" << len << endl;
    Receive(s, len);
    return len;
  }
  else {
    cout << "RawInOutBuffStream::CopyFromRecv/DBG-2 - n=" << n << endl;
    if (_rdbuff.cpos == _rdbuff.sz)  ReceiveBuffer();
    size_t len = _rdbuff.sz-_rdbuff.cpos;
    if (len > n) len = n;
    memcpy(s, _rdbuff.buff+_rdbuff.cpos, len);
    _rdbuff.cpos += len;
    return len;
  }
}

/* --Methode-- */
void RawInOutBuffStream::SendBuffer()
{
  cout << "RawInOutBuffStream::SendBuffer/DBG - cpos=" 
       <<  _wrbuff.cpos << " sz=" << _wrbuff.sz << endl;
  //  if (_wrbuff.cpos != _wrbuff.sz)  return;
  Send(_wrbuff.buff, _wrbuff.sz);
  _wrbuff.cpos = 0;
}

/* --Methode-- */
void RawInOutBuffStream::ReceiveBuffer()
{
  //  if (_rdbuff.cpos != _rdbuff.sz)  return;
  cout << "RawInOutBuffStream::ReceiveBuffer/DBG - cpos=" 
       <<  _rdbuff.cpos << " sz=" << _rdbuff.sz << endl;
  Receive(_rdbuff.buff, _rdbuff.sz);
  _rdbuff.cpos = 0;
  
}

/* --Methode-- */
size_t RawInOutBuffStream::Send(const char* s, size_t n)
{
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = fwrite(s, 1, n, _fip);;
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) 
    throw IOExc("RawInOutBuffStream::Send()/write() Error nwrite < n");
  return nst;
}

/* --Methode-- */
size_t RawInOutBuffStream::Receive(char* s, size_t n)
{
  size_t  nst = 0;
  int ntry = 0;
  while (nst < n) {
    size_t ns = fread(s, 1, n, _fip);
    ntry++;
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) {
    cout << "  RawInOutBuffStream::Receive() / Pb ! ntry=" << ntry
	 << " nst=" << nst << " n=" << n << endl;
    throw IOExc("RawInOutBuffStream::Receive/read() Error nread < n");
  }
  return nst;
}

/* --Methode-- */
int_8 RawInOutBuffStream::tellg()
{
  return _totnrd;
}

/* --Methode-- */
RawInOutStream& RawInOutBuffStream::read(char* s, uint_8 n)
{
  cout << "RawInOutBuffStream::read()/DBG - n=" << n << endl;
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = CopyFromRecvBuffer(s+nst, n-nst);
    if (ns < 1)  break;
    nst += ns;
  }
  if ( nst < n) 
    throw IOExc("RawInOutBuffStream::read() Error nread < n");
  _totnrd += n;
  return *this;
}

/* --Methode-- */
int_8 RawInOutBuffStream::tellp()
{
  return _totnwr;
}

/* --Methode-- */
RawInOutStream& RawInOutBuffStream::write(const char* s, uint_8 n)
{
  cout << "RawInOutBuffStream::write()/DBG - n=" << n << endl;
  size_t  nst = 0;
  while (nst < n) {
    size_t ns = CopyToSendBuffer(s+nst, n-nst);
    if (ns < 1)  break;
    nst += ns;
  }
  cout << "RawInOutBuffStream::write()/DBG ---> nst=" << nst << endl;
  
  if ( nst < n) 
    throw IOExc("RawInOutBuffStream::write() Error nwrite < n");
  _totnwr += n;
  return *this;
}


